/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.transaction.handler;

import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateSmartContract;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.SmartContractMethodExecution;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.VirtualMerkleTransaction;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapKey;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapValue;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapValue;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapValue;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.VirtualValue;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;

public class VirtualMerkleTransactionHandler {
    private static final Logger logger = LogManager.getLogger(VirtualMerkleTransactionHandler.class);
    private static final Marker LOGM_DEMO_INFO = LogMarker.DEMO_INFO.getMarker();

    public static void handle(Instant consensusTimestamp, VirtualMerkleTransaction virtualMerkleTransaction, ExpectedFCMFamily expectedFCMFamily, VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> accountVirtualMap, VirtualMap<SmartContractMapKey, SmartContractMapValue> smartContractVirtualMap, VirtualMap<SmartContractByteCodeMapKey, SmartContractByteCodeMapValue> smartContractByteCodeVirtualMap) {
        Triple<Object, Object, MapValueData> expectedMapInfo = virtualMerkleTransaction.hasCreateAccount() ? VirtualMerkleTransactionHandler.handleCreateAccountTransaction(virtualMerkleTransaction.getCreateAccount(), accountVirtualMap) : (virtualMerkleTransaction.hasDeleteAccount() ? VirtualMerkleTransactionHandler.handleDeleteAccountTransaction(virtualMerkleTransaction.getDeleteAccount(), accountVirtualMap) : (virtualMerkleTransaction.hasUpdateAccount() ? VirtualMerkleTransactionHandler.handleUpdateAccountTransaction(virtualMerkleTransaction.getUpdateAccount(), accountVirtualMap) : null));
        if (expectedMapInfo != null) {
            VirtualMerkleTransactionHandler.saveExpectedMapInfo(consensusTimestamp, virtualMerkleTransaction, expectedFCMFamily, expectedMapInfo.left(), expectedMapInfo.middle(), expectedMapInfo.right());
            return;
        }
        if (virtualMerkleTransaction.hasSmartContract()) {
            VirtualMerkleTransactionHandler.handleCreateSmartContractTransaction(virtualMerkleTransaction.getSmartContract(), smartContractVirtualMap, smartContractByteCodeVirtualMap);
        } else if (virtualMerkleTransaction.hasMethodExecution()) {
            VirtualMerkleTransactionHandler.handleMethodExecutionTransaction(virtualMerkleTransaction.getMethodExecution(), smartContractVirtualMap, smartContractByteCodeVirtualMap);
        }
    }

    private static void saveExpectedMapInfo(Instant consensusTimestamp, VirtualMerkleTransaction virtualMerkleTransaction, ExpectedFCMFamily expectedFCMFamily, TransactionType transactionType, MapKey key, MapValueData value) {
        if (virtualMerkleTransaction.getSampled()) {
            expectedFCMFamily.setLatestHandledStatusForKey(key, EntityType.VIRTUAL_MERKLE_ACCOUNT, value, TransactionState.HANDLED, transactionType, consensusTimestamp.getEpochSecond(), virtualMerkleTransaction.getOriginNode(), false);
        }
    }

    private static void handleMethodExecutionTransaction(SmartContractMethodExecution methodExecution, VirtualMap<SmartContractMapKey, SmartContractMapValue> smartContractVirtualMap, VirtualMap<SmartContractByteCodeMapKey, SmartContractByteCodeMapValue> smartContractByteCodeVirtualMap) {
        SmartContractMapValue smartContractMapValue;
        SmartContractMapKey smartContractMapKey;
        long keyValuePairIdx;
        SmartContractByteCodeMapKey byteCodeKey = new SmartContractByteCodeMapKey(methodExecution.getContractId());
        SmartContractByteCodeMapValue smartContractByteCodeMapValue = (SmartContractByteCodeMapValue)smartContractByteCodeVirtualMap.get((VirtualKey)byteCodeKey);
        if (smartContractByteCodeMapValue == null) {
            logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract bytecode map.", (Object)byteCodeKey);
            return;
        }
        SmartContractMapKey contractKey = new SmartContractMapKey(methodExecution.getContractId(), 0L);
        SmartContractMapValue smartContractKeyValuePairsCounter = (SmartContractMapValue)smartContractVirtualMap.get((VirtualKey)contractKey);
        if (smartContractKeyValuePairsCounter == null) {
            logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract map.", (Object)contractKey);
            return;
        }
        long totalKeyValuePairs = smartContractKeyValuePairsCounter.getValueAsLong();
        PTTRandom pttRandom = new PTTRandom(methodExecution.getSeed());
        int i = 0;
        while ((long)i < methodExecution.getReads()) {
            keyValuePairIdx = pttRandom.nextLong(1L, totalKeyValuePairs + 1L);
            smartContractMapKey = new SmartContractMapKey(methodExecution.getContractId(), keyValuePairIdx);
            smartContractMapValue = (SmartContractMapValue)smartContractVirtualMap.get((VirtualKey)smartContractMapKey);
            if (smartContractMapValue == null) {
                logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract map.", (Object)smartContractMapKey);
                return;
            }
            ++i;
        }
        i = 0;
        while ((long)i < methodExecution.getWrites()) {
            keyValuePairIdx = pttRandom.nextLong(1L, totalKeyValuePairs + 1L);
            smartContractMapKey = new SmartContractMapKey(methodExecution.getContractId(), keyValuePairIdx);
            smartContractMapValue = (SmartContractMapValue)smartContractVirtualMap.get((VirtualKey)smartContractMapKey);
            if (smartContractMapValue == null) {
                logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract map.", (Object)smartContractMapKey);
                return;
            }
            SmartContractMapValue mutableSmartContractMapValue = smartContractMapValue.copy();
            mutableSmartContractMapValue.changeValue(pttRandom);
            smartContractVirtualMap.put((VirtualKey)smartContractMapKey, (VirtualValue)mutableSmartContractMapValue);
            ++i;
        }
        for (long i2 = totalKeyValuePairs + 1L; i2 <= totalKeyValuePairs + methodExecution.getAdds(); ++i2) {
            SmartContractMapKey smartContractMapKey2 = new SmartContractMapKey(methodExecution.getContractId(), i2);
            smartContractVirtualMap.put((VirtualKey)smartContractMapKey2, (VirtualValue)new SmartContractMapValue(pttRandom));
        }
        smartContractVirtualMap.put((VirtualKey)contractKey, (VirtualValue)new SmartContractMapValue(totalKeyValuePairs + methodExecution.getAdds()));
    }

    private static void handleCreateSmartContractTransaction(CreateSmartContract smartContract, VirtualMap<SmartContractMapKey, SmartContractMapValue> smartContractVirtualMap, VirtualMap<SmartContractByteCodeMapKey, SmartContractByteCodeMapValue> smartContractByteCodeVirtualMap) {
        PTTRandom random = new PTTRandom(smartContract.getSeed());
        int i = 1;
        while ((long)i <= smartContract.getTotalValuePairs()) {
            smartContractVirtualMap.put((VirtualKey)new SmartContractMapKey(smartContract.getContractId(), i), (VirtualValue)new SmartContractMapValue(random));
            ++i;
        }
        smartContractVirtualMap.put((VirtualKey)new SmartContractMapKey(smartContract.getContractId(), 0L), (VirtualValue)new SmartContractMapValue(smartContract.getTotalValuePairs()));
        SmartContractByteCodeMapKey byteCodeKey = new SmartContractByteCodeMapKey(smartContract.getContractId());
        SmartContractByteCodeMapValue byteCodeValue = new SmartContractByteCodeMapValue(random, smartContract.getByteCodeSize());
        smartContractByteCodeVirtualMap.put((VirtualKey)byteCodeKey, (VirtualValue)byteCodeValue);
    }

    private static Triple<TransactionType, MapKey, MapValueData> handleUpdateAccountTransaction(UpdateAccount updateAccount, VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> accountVirtualMap) {
        TransactionType transactionType;
        MapValueData value;
        AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(updateAccount.getRealmID(), updateAccount.getShardID(), updateAccount.getAccountID());
        if (accountVirtualMap.containsKey((VirtualKey)accountVirtualMapKey)) {
            AccountVirtualMapValue currentValue = (AccountVirtualMapValue)accountVirtualMap.get((VirtualKey)accountVirtualMapKey);
            AccountVirtualMapValue newValue = new AccountVirtualMapValue(updateAccount.getBalance(), updateAccount.getSendThreshold(), updateAccount.getReceiveThreshold(), updateAccount.getRequireSignature(), currentValue.getUid());
            accountVirtualMap.put((VirtualKey)accountVirtualMapKey, (VirtualValue)newValue);
            value = new MapValueData(newValue.getBalance(), newValue.getSendThreshold(), newValue.getReceiveThreshold(), newValue.isRequireSignature(), newValue.getUid());
            transactionType = TransactionType.Update;
        } else {
            value = new MapValueData(updateAccount.getBalance(), updateAccount.getSendThreshold(), updateAccount.getReceiveThreshold(), updateAccount.getRequireSignature(), -1L);
            transactionType = TransactionType.UpdateNotExistentAccount;
        }
        MapKey key = new MapKey(updateAccount.getShardID(), updateAccount.getRealmID(), updateAccount.getAccountID());
        value.setKey(key);
        return Triple.of(transactionType, key, value);
    }

    private static Triple<TransactionType, MapKey, MapValueData> handleDeleteAccountTransaction(DeleteAccount deleteAccount, VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> accountVirtualMap) {
        AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(deleteAccount.getRealmID(), deleteAccount.getShardID(), deleteAccount.getAccountID());
        VirtualValue removedValue = accountVirtualMap.remove((VirtualKey)accountVirtualMapKey);
        MapKey key = new MapKey(deleteAccount.getShardID(), deleteAccount.getRealmID(), deleteAccount.getAccountID());
        TransactionType transactionType = removedValue == null ? TransactionType.DeleteNotExistentAccount : TransactionType.Delete;
        return Triple.of(transactionType, key, null);
    }

    private static Triple<TransactionType, MapKey, MapValueData> handleCreateAccountTransaction(CreateAccount createAccount, VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> accountVirtualMap) {
        AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(createAccount.getRealmID(), createAccount.getShardID(), createAccount.getAccountID());
        AccountVirtualMapValue accountVirtualMapValue = new AccountVirtualMapValue(createAccount.getBalance(), createAccount.getSendThreshold(), createAccount.getReceiveThreshold(), createAccount.getRequireSignature(), createAccount.getUid());
        TransactionType transactionType = accountVirtualMap.containsKey((VirtualKey)accountVirtualMapKey) ? TransactionType.CreateExistingAccount : TransactionType.Create;
        accountVirtualMap.put((VirtualKey)accountVirtualMapKey, (VirtualValue)accountVirtualMapValue);
        MapKey key = new MapKey(createAccount.getShardID(), createAccount.getRealmID(), createAccount.getAccountID());
        MapValueData value = new MapValueData(createAccount.getBalance(), createAccount.getSendThreshold(), createAccount.getReceiveThreshold(), createAccount.getRequireSignature(), createAccount.getUid());
        value.setKey(key);
        return Triple.of(transactionType, key, value);
    }

    public static void handleExpectedMapValidation(ExpectedFCMFamily expectedFCMFamily, VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> virtualMap) {
        if (virtualMap == null) {
            return;
        }
        AtomicBoolean notMismatching = new AtomicBoolean(true);
        expectedFCMFamily.getExpectedMap().forEach((mapKey, expectedValue) -> {
            if (expectedValue.getEntityType() != EntityType.VIRTUAL_MERKLE_ACCOUNT) {
                return;
            }
            AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(mapKey.getRealmId(), mapKey.getShardId(), mapKey.getAccountId());
            TransactionType lastTransactionType = expectedValue.getLatestHandledStatus().getTransactionType();
            if (lastTransactionType == TransactionType.Create || lastTransactionType == TransactionType.Update) {
                AccountVirtualMapValue virtualMapValue = (AccountVirtualMapValue)virtualMap.get((VirtualKey)accountVirtualMapKey);
                if (virtualMapValue == null) {
                    notMismatching.set(false);
                    logger.warn(LogMarker.DEMO_INFO.getMarker(), "An account from the expected map is not present inside the state.");
                    return;
                }
                MapValueData mapValueData = new MapValueData(virtualMapValue.getBalance(), virtualMapValue.getSendThreshold(), virtualMapValue.getReceiveThreshold(), virtualMapValue.isRequireSignature(), virtualMapValue.getUid());
                if (!mapValueData.calculateHash().equals((Object)expectedValue.getHash())) {
                    notMismatching.set(false);
                }
            } else if (lastTransactionType == TransactionType.CreateExistingAccount) {
                if (!virtualMap.containsKey((VirtualKey)accountVirtualMapKey)) {
                    notMismatching.set(false);
                    logger.warn(LogMarker.DEMO_INFO.getMarker(), "A created account does not exist inside the state.");
                }
            } else if ((lastTransactionType == TransactionType.Delete || lastTransactionType == TransactionType.DeleteNotExistentAccount || lastTransactionType == TransactionType.UpdateNotExistentAccount) && virtualMap.containsKey((VirtualKey)accountVirtualMapKey)) {
                notMismatching.set(false);
                logger.warn(LogMarker.DEMO_INFO.getMarker(), "A deleted account is still present inside the state.");
            }
        });
        if (notMismatching.get()) {
            logger.info(LOGM_DEMO_INFO, "There was no mismatch between the expected map and state.");
        }
    }
}

