/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskKeySerializer;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.disk.OnDiskValueSerializer;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.merkle.singleton.StringLeaf;
import com.swirlds.state.merkle.singleton.ValueLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;

public final class StateUtils {
    private StateUtils() {
    }

    public static <T> int writeToStream(@NonNull OutputStream out, @NonNull Codec<T> codec, @Nullable T object) throws IOException {
        WritableStreamingData stream = new WritableStreamingData(out);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        codec.write(object, (WritableSequentialData)new WritableStreamingData((OutputStream)byteStream));
        stream.writeInt(byteStream.size());
        stream.writeBytes(byteStream.toByteArray());
        return byteStream.size();
    }

    @Nullable
    public static <T> T readFromStream(@NonNull InputStream in, @NonNull Codec<T> codec) throws IOException {
        ReadableStreamingData stream = new ReadableStreamingData(in);
        int size = stream.readInt();
        stream.limit((long)size + 4L);
        try {
            return (T)codec.parse((ReadableSequentialData)stream);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    public static void registerWithSystem(@NonNull StateMetadata md, @NonNull ConstructableRegistry constructableRegistry) {
        try {
            constructableRegistry.registerConstructable(new ClassConstructorPair(InMemoryValue.class, () -> new InMemoryValue(md.inMemoryValueClassId(), md.stateDefinition().keyCodec(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskKey.class, () -> new OnDiskKey(md.onDiskKeyClassId(), md.stateDefinition().keyCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskKeySerializer.class, () -> new OnDiskKeySerializer(md.onDiskKeySerializerClassId(), md.onDiskKeyClassId(), md.stateDefinition().keyCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskValue.class, () -> new OnDiskValue(md.onDiskValueClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskValueSerializer.class, () -> new OnDiskValueSerializer(md.onDiskValueSerializerClassId(), md.onDiskValueClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(SingletonNode.class, () -> new SingletonNode<Object>(md.serviceName(), md.stateDefinition().stateKey(), md.singletonClassId(), md.stateDefinition().valueCodec(), null)));
            constructableRegistry.registerConstructable(new ClassConstructorPair(QueueNode.class, () -> new QueueNode(md.serviceName(), md.stateDefinition().stateKey(), md.queueNodeClassId(), md.singletonClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(StringLeaf.class, StringLeaf::new));
            constructableRegistry.registerConstructable(new ClassConstructorPair(ValueLeaf.class, () -> new ValueLeaf(md.singletonClassId(), md.stateDefinition().valueCodec())));
        }
        catch (ConstructableRegistryException e) {
            throw new IllegalStateException("Failed to register with the system '" + md.serviceName() + ":" + md.stateDefinition().stateKey() + "'", e);
        }
    }
}

