/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.communication;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.IOConsumer;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.test.fixtures.sync.FakeConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ReadWriteFakeConnection
extends FakeConnection {
    private final SyncInputStream in;
    private final SyncOutputStream out;
    private final Configuration configuration = new TestConfigBuilder().withValue("socket.gzipCompression", false).getOrCreateConfig();
    private final PlatformContext platformContext = TestPlatformContextBuilder.create().withConfiguration(this.configuration).build();

    public ReadWriteFakeConnection(InputStream in, OutputStream out) {
        this.in = SyncInputStream.createSyncInputStream((PlatformContext)this.platformContext, (InputStream)in, (int)100);
        this.out = SyncOutputStream.createSyncOutputStream((PlatformContext)this.platformContext, (OutputStream)out, (int)100);
    }

    public ReadWriteFakeConnection(InputStream in, final OutputStream out, final IOConsumer<Integer> outputInterceptor) {
        this.in = SyncInputStream.createSyncInputStream((PlatformContext)this.platformContext, (InputStream)in, (int)100);
        OutputStream baseOutput = new OutputStream(this){

            @Override
            public void write(int b) throws IOException {
                if (outputInterceptor != null) {
                    outputInterceptor.accept((Object)b);
                }
                out.write(b);
            }
        };
        this.out = SyncOutputStream.createSyncOutputStream((PlatformContext)this.platformContext, (OutputStream)baseOutput, (int)100);
    }

    @Override
    public SyncInputStream getDis() {
        return this.in;
    }

    @Override
    public SyncOutputStream getDos() {
        return this.out;
    }
}

