/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.merkledb.test.fixtures.ExampleLongKeyFixedSize;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.serialize.KeySerializer;
import java.io.IOException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class ExampleLongKeyVariableSize
implements VirtualKey {
    private static final int CURRENT_SERIALIZATION_VERSION = 8483;
    private long value;
    private int hashCode;

    public ExampleLongKeyVariableSize() {
    }

    public ExampleLongKeyVariableSize(long value) {
        this.setValue(value);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.hashCode = Long.hashCode(value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void serialize(WritableSequentialData out) {
        byte numOfBytes = ExampleLongKeyVariableSize.computeNonZeroBytes(this.value);
        out.writeByte(numOfBytes);
        for (int b = numOfBytes - 1; b >= 0; --b) {
            out.writeByte((byte)(this.value >> b * 8));
        }
    }

    public void deserialize(ReadableSequentialData in) {
        byte numOfBytes = in.readByte();
        long value = 0L;
        if (numOfBytes >= 8) {
            value |= ((long)in.readByte() & 0xFFL) << 56;
        }
        if (numOfBytes >= 7) {
            value |= ((long)in.readByte() & 0xFFL) << 48;
        }
        if (numOfBytes >= 6) {
            value |= ((long)in.readByte() & 0xFFL) << 40;
        }
        if (numOfBytes >= 5) {
            value |= ((long)in.readByte() & 0xFFL) << 32;
        }
        if (numOfBytes >= 4) {
            value |= ((long)in.readByte() & 0xFFL) << 24;
        }
        if (numOfBytes >= 3) {
            value |= ((long)in.readByte() & 0xFFL) << 16;
        }
        if (numOfBytes >= 2) {
            value |= ((long)in.readByte() & 0xFFL) << 8;
        }
        if (numOfBytes >= 1) {
            value |= (long)in.readByte() & 0xFFL;
        }
        this.setValue(value);
    }

    public ExampleLongKeyFixedSize copy() {
        return new ExampleLongKeyFixedSize(this.value);
    }

    public void serialize(SerializableDataOutputStream outputStream) throws IOException {
        byte numOfBytes = ExampleLongKeyVariableSize.computeNonZeroBytes(this.value);
        outputStream.write((int)numOfBytes);
        for (int b = numOfBytes - 1; b >= 0; --b) {
            outputStream.write((int)((byte)(this.value >> b * 8)));
        }
    }

    public void deserialize(SerializableDataInputStream in, int dataVersion) throws IOException {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        byte numOfBytes = in.readByte();
        long value = 0L;
        if (numOfBytes >= 8) {
            value |= ((long)in.readByte() & 0xFFL) << 56;
        }
        if (numOfBytes >= 7) {
            value |= ((long)in.readByte() & 0xFFL) << 48;
        }
        if (numOfBytes >= 6) {
            value |= ((long)in.readByte() & 0xFFL) << 40;
        }
        if (numOfBytes >= 5) {
            value |= ((long)in.readByte() & 0xFFL) << 32;
        }
        if (numOfBytes >= 4) {
            value |= ((long)in.readByte() & 0xFFL) << 24;
        }
        if (numOfBytes >= 3) {
            value |= ((long)in.readByte() & 0xFFL) << 16;
        }
        if (numOfBytes >= 2) {
            value |= ((long)in.readByte() & 0xFFL) << 8;
        }
        if (numOfBytes >= 1) {
            value |= (long)in.readByte() & 0xFFL;
        }
        this.setValue(value);
    }

    public long getClassId() {
        return 5614541343884544469L;
    }

    public int getVersion() {
        return 8483;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExampleLongKeyVariableSize)) {
            return false;
        }
        ExampleLongKeyVariableSize that = (ExampleLongKeyVariableSize)o;
        return this.value == that.value;
    }

    public String toString() {
        return "ExampleVariableSizeLongKey{value=" + this.value + ", hashCode=" + this.hashCode + "}";
    }

    static byte computeNonZeroBytes(long num) {
        if (num == 0L) {
            return 1;
        }
        return (byte)Math.ceil((double)(64 - Long.numberOfLeadingZeros(num)) / 8.0);
    }

    public static class Serializer
    implements KeySerializer<ExampleLongKeyVariableSize> {
        private static final long CLASS_ID = -8303200006898776345L;

        public long getClassId() {
            return -8303200006898776345L;
        }

        public int getVersion() {
            return 1;
        }

        public int getTypicalSerializedSize() {
            return 9;
        }

        public int getSerializedSize() {
            return -1;
        }

        public long getCurrentDataVersion() {
            return 8483L;
        }

        public int getSerializedSize(ExampleLongKeyVariableSize data) {
            return 1 + ExampleLongKeyVariableSize.computeNonZeroBytes(data.getValue());
        }

        public ExampleLongKeyVariableSize deserialize(ReadableSequentialData in) {
            ExampleLongKeyVariableSize key = new ExampleLongKeyVariableSize();
            key.deserialize(in);
            return key;
        }

        public void serialize(ExampleLongKeyVariableSize data, WritableSequentialData out) {
            data.serialize(out);
        }

        public boolean equals(BufferedData buffer, ExampleLongKeyVariableSize keyToCompare) {
            byte numOfBytes = buffer.readByte();
            long value = 0L;
            if (numOfBytes >= 8) {
                value |= ((long)buffer.readByte() & 0xFFL) << 56;
            }
            if (numOfBytes >= 7) {
                value |= ((long)buffer.readByte() & 0xFFL) << 48;
            }
            if (numOfBytes >= 6) {
                value |= ((long)buffer.readByte() & 0xFFL) << 40;
            }
            if (numOfBytes >= 5) {
                value |= ((long)buffer.readByte() & 0xFFL) << 32;
            }
            if (numOfBytes >= 4) {
                value |= ((long)buffer.readByte() & 0xFFL) << 24;
            }
            if (numOfBytes >= 3) {
                value |= ((long)buffer.readByte() & 0xFFL) << 16;
            }
            if (numOfBytes >= 2) {
                value |= ((long)buffer.readByte() & 0xFFL) << 8;
            }
            if (numOfBytes >= 1) {
                value |= (long)buffer.readByte() & 0xFFL;
            }
            return value == keyToCompare.getValue();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Serializer;
        }

        private static final class ClassVersion {
            public static final int ORIGINAL = 1;

            private ClassVersion() {
            }
        }
    }
}

