/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.crypto;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.demo.crypto.CryptocurrencyDemoState;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class CryptocurrencyDemoConsensusStateEventHandler
implements ConsensusStateEventHandler<CryptocurrencyDemoState> {
    private static final Logger logger = LogManager.getLogger(CryptocurrencyDemoConsensusStateEventHandler.class);

    public void onStateInitialized(@NonNull CryptocurrencyDemoState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
        if (trigger == InitTrigger.GENESIS) {
            state.genesisInit(platform);
        }
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull CryptocurrencyDemoState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        round.forEachEventTransaction((event, transaction) -> {
            if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                this.consumeSystemTransaction((Transaction)transaction, (Event)event, stateSignatureTransactionCallback);
            }
            this.handleTransaction(event.getCreatorId(), (Transaction)transaction, state);
        });
    }

    private void handleTransaction(@NonNull NodeId id, @NonNull Transaction transaction, @NonNull CryptocurrencyDemoState state) {
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(transaction, "transaction must not be null");
        Bytes contents = transaction.getApplicationTransaction();
        if (contents.length() < 3L) {
            return;
        }
        if (contents.getByte(0L) == CryptocurrencyDemoState.TransType.slow.ordinal() || contents.getByte(0L) == CryptocurrencyDemoState.TransType.fast.ordinal()) {
            return;
        }
        byte askBid = contents.getByte(0L);
        byte tradeStock = contents.getByte(1L);
        byte tradePrice = contents.getByte(2L);
        if (tradePrice < 1 || tradePrice > 127) {
            return;
        }
        state.handleTransaction(id, askBid, tradeStock, tradePrice);
    }

    public void onPreHandle(@NonNull Event event, @NonNull CryptocurrencyDemoState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(t -> {
            if (this.areTransactionBytesSystemOnes((Transaction)t)) {
                this.consumeSystemTransaction((Transaction)t, event, stateSignatureTransactionCallback);
            }
        });
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull CryptocurrencyDemoState state) {
        return true;
    }

    public void onUpdateWeight(@NonNull CryptocurrencyDemoState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull CryptocurrencyDemoState recoveredState) {
    }

    private void consumeSystemTransaction(Transaction transaction, Event event, Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }

    private boolean areTransactionBytesSystemOnes(Transaction transaction) {
        return transaction.getApplicationTransaction().length() > 3L;
    }
}

