/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashLeafFlusher;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReconnectNodeRemover<K extends VirtualKey, V extends VirtualValue> {
    private static final Logger logger = LogManager.getLogger(ReconnectNodeRemover.class);
    private long newLastLeafPath;
    private final RecordAccessor<K, V> oldRecords;
    private final long oldFirstLeafPath;
    private final long oldLastLeafPath;
    private final ReconnectHashLeafFlusher<K, V> flusher;

    public ReconnectNodeRemover(@NonNull RecordAccessor<K, V> oldRecords, long oldFirstLeafPath, long oldLastLeafPath, @NonNull ReconnectHashLeafFlusher<K, V> flusher) {
        this.oldRecords = oldRecords;
        this.oldFirstLeafPath = oldFirstLeafPath;
        this.oldLastLeafPath = oldLastLeafPath;
        this.flusher = flusher;
    }

    public synchronized void setPathInformation(long newFirstLeafPath, long newLastLeafPath) {
        this.flusher.start(newFirstLeafPath, newLastLeafPath);
        this.newLastLeafPath = newLastLeafPath;
        if (this.oldLastLeafPath > 0L) {
            for (long path = this.oldFirstLeafPath; path < Math.min(newFirstLeafPath, this.oldLastLeafPath + 1L); ++path) {
                VirtualLeafRecord<K, V> oldRecord = this.oldRecords.findLeafRecord(path, false);
                assert (oldRecord != null);
                this.flusher.deleteLeaf(oldRecord);
            }
        }
    }

    public synchronized void newLeafNode(long path, K newKey) {
        VirtualLeafRecord<K, V> oldRecord = this.oldRecords.findLeafRecord(path, false);
        if (oldRecord != null && !newKey.equals(oldRecord.getKey())) {
            this.flusher.deleteLeaf(oldRecord);
        }
    }

    public synchronized void allNodesReceived() {
        long firstOldStalePath;
        logger.info(LogMarker.RECONNECT.getMarker(), "allNodesReceived(): newLastLeafPath = " + this.newLastLeafPath + ", oldLastLeafPath = " + this.oldLastLeafPath);
        for (long p = firstOldStalePath = this.newLastLeafPath == -1L ? 1L : this.newLastLeafPath + 1L; p <= this.oldLastLeafPath; ++p) {
            VirtualLeafRecord<K, V> oldExtraLeafRecord = this.oldRecords.findLeafRecord(p, false);
            assert (oldExtraLeafRecord != null || p < this.oldFirstLeafPath);
            if (oldExtraLeafRecord == null) continue;
            this.flusher.deleteLeaf(oldExtraLeafRecord);
        }
    }
}

