/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures.files;

import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.merkledb.collections.LongList;
import com.swirlds.merkledb.collections.LongListHeap;
import com.swirlds.merkledb.files.DataFileCollection;
import com.swirlds.merkledb.test.fixtures.files.FilesTestType;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;

public class DataFileCollectionTestUtils {
    private static int getRepeatCountForKey(long key) {
        return (int)(key % 20L);
    }

    public static long[] getVariableSizeDataForI(int i, int valueAddition) {
        int repeatCount = DataFileCollectionTestUtils.getRepeatCountForKey(i);
        long[] dataValue = new long[1 + repeatCount];
        dataValue[0] = i;
        for (int j = 1; j < dataValue.length; ++j) {
            dataValue[j] = i + valueAddition;
        }
        return dataValue;
    }

    public static void checkData(DataFileCollection fileCollection, LongListHeap storedOffsets, FilesTestType testType, int fromIndex, int toIndexExclusive, int valueAddition) {
        for (int i = fromIndex; i < toIndexExclusive; ++i) {
            long fi = i;
            BufferedData dataItem = (BufferedData)Assertions.assertDoesNotThrow(() -> fileCollection.readDataItemUsingIndex((LongList)storedOffsets, fi), (String)"Read should not a exception.");
            DataFileCollectionTestUtils.checkDataItem(testType, valueAddition, dataItem, i);
        }
    }

    static void checkDataItem(FilesTestType testType, int valueAddition, BufferedData dataItem, int expectedKey) {
        Assertions.assertNotNull((Object)dataItem, (String)"dataItem should not be null");
        switch (testType) {
            default: {
                Assertions.assertEquals((long)16L, (long)dataItem.remaining(), (String)"unexpected length");
                Assertions.assertEquals((long)expectedKey, (long)dataItem.readLong(), (String)"unexpected key");
                Assertions.assertEquals((long)(expectedKey + valueAddition), (long)dataItem.readLong(), (String)"unexpected value");
                break;
            }
            case variable: {
                long[] dataItemLongs = new long[Math.toIntExact(dataItem.remaining() / 8L)];
                for (int i = 0; i < dataItemLongs.length; ++i) {
                    dataItemLongs[i] = dataItem.readLong();
                }
                Assertions.assertEquals((Object)Arrays.toString(DataFileCollectionTestUtils.getVariableSizeDataForI(expectedKey, valueAddition)), (Object)Arrays.toString(dataItemLongs), (String)"unexpected dataItem value");
            }
        }
    }
}

