/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Hashable;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.EventMetadata;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.TransactionWrapper;

public class UnsignedEvent
implements Hashable {
    private final EventCore eventCore;
    private final List<Bytes> transactions;
    private final EventMetadata metadata;
    private final List<EventDescriptor> parents;

    public UnsignedEvent(@NonNull NodeId creatorId, @Nullable EventDescriptorWrapper selfParent, @NonNull List<EventDescriptorWrapper> otherParents, long birthRound, @NonNull Instant timeCreated, @NonNull List<Bytes> transactions) {
        this.transactions = Objects.requireNonNull(transactions, "transactions must not be null");
        this.metadata = new EventMetadata(creatorId, selfParent, otherParents, timeCreated, transactions, birthRound);
        this.parents = this.metadata.getAllParents().stream().map(EventDescriptorWrapper::eventDescriptor).toList();
        this.eventCore = new EventCore(creatorId.id(), birthRound, HapiUtils.asTimestamp((Instant)timeCreated), null);
    }

    public EventMetadata getMetadata() {
        return this.metadata;
    }

    @NonNull
    public Instant getTimeCreated() {
        return this.metadata.getTimeCreated();
    }

    @NonNull
    public List<TransactionWrapper> getTransactions() {
        return this.metadata.getTransactions();
    }

    @NonNull
    public EventDescriptorWrapper getDescriptor() {
        return this.metadata.getDescriptor();
    }

    @NonNull
    public EventCore getEventCore() {
        return this.eventCore;
    }

    @NonNull
    public List<EventDescriptor> getParents() {
        return this.parents;
    }

    @NonNull
    public List<Bytes> getTransactionsBytes() {
        return this.transactions;
    }

    @Nullable
    public Hash getHash() {
        return this.metadata.getHash();
    }

    public void setHash(Hash hash) {
        this.metadata.setHash(hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedEvent that = (UnsignedEvent)o;
        return Objects.equals(this.eventCore, that.eventCore) && Objects.equals(this.transactions, that.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.eventCore, this.transactions);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.eventCore).append(this.transactions).append("hash", (Object)(this.getHash() == null ? "null" : this.getHash().toHex(5))).toString();
    }
}

