/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockrecords.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class BlockInfoJsonCodec
implements JsonCodec<BlockInfo> {
    @NonNull
    public BlockInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_last_block_number = 0L;
            Timestamp temp_first_cons_time_of_last_block = null;
            Bytes temp_block_hashes = Bytes.EMPTY;
            Timestamp temp_cons_time_of_last_handled_txn = null;
            boolean temp_migration_records_streamed = false;
            Timestamp temp_first_cons_time_of_current_block = null;
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "lastBlockNumber": {
                        temp_last_block_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "firstConsTimeOfLastBlock": {
                        temp_first_cons_time_of_last_block = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                    case "blockHashes": {
                        temp_block_hashes = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block18;
                    }
                    case "consTimeOfLastHandledTxn": {
                        temp_cons_time_of_last_handled_txn = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                    case "migrationRecordsStreamed": {
                        temp_migration_records_streamed = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "firstConsTimeOfCurrentBlock": {
                        temp_first_cons_time_of_current_block = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockInfo(temp_last_block_number, temp_first_cons_time_of_last_block, temp_block_hashes, temp_cons_time_of_last_handled_txn, temp_migration_records_streamed, temp_first_cons_time_of_current_block);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.lastBlockNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"lastBlockNumber", (long)data.lastBlockNumber()));
        }
        if (data.firstConsTimeOfLastBlock() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"firstConsTimeOfLastBlock", Timestamp.JSON, (Object)data.firstConsTimeOfLastBlock()));
        }
        if (data.blockHashes() != Bytes.EMPTY && data.blockHashes() != null && data.blockHashes().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"blockHashes", (Bytes)data.blockHashes()));
        }
        if (data.consTimeOfLastHandledTxn() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"consTimeOfLastHandledTxn", Timestamp.JSON, (Object)data.consTimeOfLastHandledTxn()));
        }
        if (data.migrationRecordsStreamed()) {
            fieldLines.add(JsonTools.field((String)"migrationRecordsStreamed", (boolean)data.migrationRecordsStreamed()));
        }
        if (data.firstConsTimeOfCurrentBlock() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"firstConsTimeOfCurrentBlock", Timestamp.JSON, (Object)data.firstConsTimeOfCurrentBlock()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

