/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state.manager;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.PublicKey;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;

public class SignatureVerificationTestUtils {
    public static Signature buildFakeSignature(@NonNull PublicKey key, @NonNull Hash hash) {
        return new Signature(SignatureType.RSA, SignatureVerificationTestUtils.concat(key, hash.getBytes()).toByteArray());
    }

    public static Bytes buildFakeSignatureBytes(@NonNull PublicKey key, @NonNull Hash hash) {
        return SignatureVerificationTestUtils.concat(key, hash.getBytes());
    }

    public static boolean verifySignature(@NonNull Bytes data, @NonNull Bytes signature, @NonNull PublicKey publicKey) {
        return SignatureVerificationTestUtils.concat(publicKey, data).equals((Object)signature);
    }

    private static Bytes concat(@NonNull PublicKey key, @NonNull Bytes bytes) {
        Bytes keyEncoded = Bytes.wrap((byte[])key.getEncoded());
        return keyEncoded.append(bytes);
    }
}

