/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.util;

import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class LaggingAsyncOutputStream<T extends SelfSerializable>
extends AsyncOutputStream<T> {
    private final BlockingQueue<Long> messageTimes = new LinkedBlockingQueue<Long>();
    private final long latencyMilliseconds;

    public LaggingAsyncOutputStream(SerializableDataOutputStream out, StandardWorkGroup workGroup, long latencyMilliseconds, ReconnectConfig reconnectConfig) {
        super(out, workGroup, reconnectConfig);
        this.latencyMilliseconds = latencyMilliseconds;
    }

    public void sendAsync(T message) throws InterruptedException {
        if (!this.isAlive()) {
            throw new MerkleSynchronizationException("Messages can not be sent after close has been called.");
        }
        this.messageTimes.put(System.currentTimeMillis());
        this.getOutgoingMessages().put(message);
    }

    protected void serializeMessage(T message) throws IOException {
        long now;
        long messageTime = (Long)this.messageTimes.remove();
        long waitTime = messageTime + this.latencyMilliseconds - (now = System.currentTimeMillis());
        if (waitTime > 0L) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        message.serialize(this.getOutputStream());
    }
}

