/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.utility.Labeled;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.MerkleStateRoot;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.memory.InMemoryKey;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.test.fixtures.merkle.TestSchema;
import com.swirlds.virtualmap.VirtualMap;

public class MerkleTestBase
extends com.swirlds.state.test.fixtures.merkle.MerkleTestBase {
    protected SemanticVersion v1 = SemanticVersion.newBuilder().major(1).build();
    protected StateMetadata<String, String> fruitMetadata;
    protected StateMetadata<String, String> fruitVirtualMetadata;
    protected StateMetadata<String, String> animalMetadata;
    protected StateMetadata<Long, String> spaceMetadata;
    protected StateMetadata<String, String> steamMetadata;
    protected StateMetadata<String, String> countryMetadata;

    protected void setupFruitMerkleMap() {
        super.setupFruitMerkleMap();
        this.fruitMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.inMemory((String)"FRUIT", (Codec)STRING_CODEC, (Codec)STRING_CODEC));
    }

    protected void setupFruitVirtualMap() {
        super.setupFruitVirtualMap();
        this.fruitVirtualMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.onDisk((String)"FRUIT", (Codec)STRING_CODEC, (Codec)STRING_CODEC, (long)100L));
    }

    protected void setupAnimalMerkleMap() {
        super.setupAnimalMerkleMap();
        this.animalMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.inMemory((String)"ANIMAL", (Codec)STRING_CODEC, (Codec)STRING_CODEC));
    }

    protected void setupSpaceMerkleMap() {
        super.setupSpaceMerkleMap();
        this.spaceMetadata = new StateMetadata("Second-Service", (Schema)new TestSchema(1), StateDefinition.inMemory((String)"SPACE", (Codec)LONG_CODEC, (Codec)STRING_CODEC));
    }

    protected void setupSingletonCountry() {
        super.setupSingletonCountry();
        this.countryMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.singleton((String)"COUNTRY", (Codec)STRING_CODEC));
    }

    protected void setupSteamQueue() {
        super.setupSteamQueue();
        this.steamMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.queue((String)"STEAM", (Codec)STRING_CODEC));
    }

    protected VirtualMap<OnDiskKey<String>, OnDiskValue<String>> createVirtualMap(String label, StateMetadata<String, String> md) {
        return this.createVirtualMap(label, md.onDiskKeySerializerClassId(), md.onDiskKeyClassId(), md.stateDefinition().keyCodec(), md.onDiskValueSerializerClassId(), md.onDiskValueClassId(), md.stateDefinition().valueCodec());
    }

    protected MerkleNode getNodeForLabel(MerkleStateRoot stateRoot, String label) {
        int n = stateRoot.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            Labeled labeled;
            MerkleNode child = stateRoot.getChild(i);
            if (!(child instanceof Labeled) || !label.equals((labeled = (Labeled)child).getLabel())) continue;
            return child;
        }
        return null;
    }

    protected void add(MerkleMap<InMemoryKey<String>, InMemoryValue<String, String>> map, StateMetadata<String, String> md, String key, String value) {
        StateDefinition def = md.stateDefinition();
        super.add(map, md.inMemoryValueClassId(), def.keyCodec(), def.valueCodec(), key, value);
    }

    protected void add(VirtualMap<OnDiskKey<String>, OnDiskValue<String>> map, StateMetadata<String, String> md, String key, String value) {
        super.add(map, md.onDiskKeyClassId(), md.stateDefinition().keyCodec(), md.onDiskValueClassId(), md.stateDefinition().valueCodec(), key, value);
    }
}

