/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stress;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Random;

final class TransactionPool {
    public static final byte APPLICATION_TRANSACTION_MARKER = 1;
    private final byte[][] transactions;
    private final Random random;

    TransactionPool(int poolSize, int transactionSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize");
        }
        if (transactionSize < 1) {
            throw new IllegalArgumentException("transactionSize");
        }
        this.random = new Random();
        this.transactions = new byte[poolSize][];
        for (int i = 0; i < this.transactions.length; ++i) {
            byte[] data = new byte[transactionSize];
            this.random.nextBytes(data);
            data[0] = 1;
            this.transactions[i] = data;
        }
    }

    @NonNull
    byte[] transaction() {
        return this.transactions[this.random.nextInt(this.transactions.length)];
    }
}

