/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundConsistencyValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public enum RoundAncientThresholdIncreasesValidation implements ConsensusRoundConsistencyValidation
{
    INSTANCE;


    @Override
    public void validate(@NonNull List<ConsensusRound> rounds) {
        if (rounds.isEmpty()) {
            return;
        }
        for (int i = 1; i < rounds.size(); ++i) {
            MinimumJudgeInfo previousThresholdInfo = (MinimumJudgeInfo)rounds.get(i - 1).getSnapshot().minimumJudgeInfoList().getLast();
            MinimumJudgeInfo currentThresholdInfo = (MinimumJudgeInfo)rounds.get(i).getSnapshot().minimumJudgeInfoList().getLast();
            ((AbstractLongAssert)Assertions.assertThat((long)currentThresholdInfo.minimumJudgeAncientThreshold()).withFailMessage("the ancient threshold should never decrease", new Object[0])).isGreaterThanOrEqualTo(previousThresholdInfo.minimumJudgeAncientThreshold());
        }
    }
}

