/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.DefaultPlatformMetrics;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.PlatformMetricsFactoryImpl;
import com.swirlds.common.test.fixtures.AssertionUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.HashBuilder;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class MerkleDbTestUtils {
    private static final long DIRECT_MEMORY_BASE_USAGE = 0x400000L;
    public static final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(MerkleDbConfig.class).withConfigDataType(VirtualMapConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).withConfigDataType(FileSystemManagerConfig.class).build();
    private static final BufferPoolMXBean DIRECT_MEMORY_POOL = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class).stream().filter(pool -> pool.getName().equals("direct")).findFirst().get();

    public static void runTaskAndCleanThreadLocals(Callable callable) throws Exception {
        long directMemoryUsedAtStart = MerkleDbTestUtils.getDirectMemoryUsedBytes();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future future = executorService.submit(callable);
        future.get(60L, TimeUnit.MINUTES);
        executorService.shutdown();
        Assertions.assertTrue((boolean)MerkleDbTestUtils.checkDirectMemoryIsCleanedUpToLessThanBaseUsage(directMemoryUsedAtStart), (String)("Direct Memory used is more than base usage even after 20 gc() calls. At start was " + (double)directMemoryUsedAtStart * 9.5367431640625E-7 + "MB and is now " + (double)MerkleDbTestUtils.getDirectMemoryUsedBytes() * 9.5367431640625E-7 + "MB"));
        Assertions.assertEquals((long)0L, (long)MerkleDbDataSource.getCountOfOpenDatabases(), (String)"Expected no open dbs");
    }

    public static void dumpHeap() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        String filePath = Path.of("heapdump-" + System.currentTimeMillis() + ".hprof", new String[0]).toAbsolutePath().toString();
        mxBean.dumpHeap(filePath, true);
        System.out.println("Dumped heap to " + filePath);
    }

    public static boolean checkDirectMemoryIsCleanedUpToLessThanBaseUsage(long directMemoryBytesBefore) {
        long limit = directMemoryBytesBefore + 0x400000L;
        if (MerkleDbTestUtils.getDirectMemoryUsedBytes() < limit) {
            return true;
        }
        for (int i = 0; i < 5 && MerkleDbTestUtils.getDirectMemoryUsedBytes() > limit; ++i) {
            System.gc();
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return MerkleDbTestUtils.getDirectMemoryUsedBytes() < limit;
    }

    public static long getDirectMemoryUsedBytes() {
        return DIRECT_MEMORY_POOL.getMemoryUsed();
    }

    public static Hash hashDirectoryContentsStatus(Path dir) {
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            HashBuilder hashBuilder = new HashBuilder(DigestType.SHA_384);
            try (Stream<Path> filesStream = Files.walk(dir, new FileVisitOption[0]);){
                filesStream.forEach(filePath -> {
                    try {
                        hashBuilder.update(filePath.getFileName().toString().getBytes());
                        BasicFileAttributes fileAttributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                        hashBuilder.update(fileAttributes.lastModifiedTime().toMillis());
                        hashBuilder.update(Files.size(filePath));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Failed to hash directory [" + dir.toFile().getAbsolutePath() + "]");
                e.printStackTrace();
            }
            return hashBuilder.build();
        }
        return null;
    }

    public static String toLongsString(Hash hash) {
        LongBuffer longBuf = ByteBuffer.wrap(hash.copyToByteArray()).order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        long[] array = new long[longBuf.remaining()];
        longBuf.get(array);
        return Arrays.toString(array);
    }

    public static String toLongsString(ByteBuffer buf) {
        buf.rewind();
        LongBuffer longBuf = buf.asLongBuffer();
        long[] array = new long[longBuf.remaining()];
        longBuf.get(array);
        buf.rewind();
        return Arrays.toString(array);
    }

    public static Hash hash(int value) {
        byte[] hardCoded = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        byte[] digest = new byte[DigestType.SHA_384.digestLength()];
        for (int i = 0; i < 6; ++i) {
            System.arraycopy(hardCoded, 0, digest, i * 6 + 4, 4);
        }
        return new Hash(digest, DigestType.SHA_384);
    }

    public static void hexDump(PrintStream out, Path file) throws IOException {
        FileInputStream is = new FileInputStream(file.toFile());
        int i = 0;
        while (((InputStream)is).available() > 0) {
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder("   ");
            out.printf("%04X  ", i * 16);
            for (int j = 0; j < 16; ++j) {
                if (((InputStream)is).available() > 0) {
                    int value = ((InputStream)is).read();
                    sb1.append(String.format("%02X ", value));
                    if (!Character.isISOControl(value)) {
                        sb2.append((char)value);
                        continue;
                    }
                    sb2.append(".");
                    continue;
                }
                while (j < 16) {
                    sb1.append("   ");
                    ++j;
                }
            }
            out.print(sb1);
            out.println(sb2);
            ++i;
        }
        ((InputStream)is).close();
    }

    public static int[] shuffle(Random random, int[] array) {
        int count;
        if (random == null) {
            random = new Random();
        }
        for (int i = count = array.length; i > 1; --i) {
            MerkleDbTestUtils.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    private static void swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    public static String randomString(int length, Random random) {
        int leftLimit = 48;
        int rightLimit = 122;
        return random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static byte[] randomUtf8Bytes(int n) {
        byte[] rnd;
        byte[] data = new byte[n];
        for (int i = 0; i < n; i += rnd.length) {
            rnd = UUID.randomUUID().toString().getBytes();
            System.arraycopy(rnd, 0, data, i, Math.min(rnd.length, n - 1 - i));
        }
        return data;
    }

    public static void ls(Path dir) {
        System.out.println("=== " + String.valueOf(dir) + " ======================================================");
        try {
            ProcessBuilder pb = new ProcessBuilder("ls", "-Rlh", dir.toAbsolutePath().toString());
            pb.inheritIO();
            pb.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("===================================================================");
    }

    public static Metrics createMetrics() {
        Configuration configuration = new TestConfigBuilder().getOrCreateConfig();
        MetricsConfig metricsConfig = (MetricsConfig)configuration.getConfigData(MetricsConfig.class);
        MetricKeyRegistry registry = new MetricKeyRegistry();
        return new DefaultPlatformMetrics(null, registry, (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class), (PlatformMetricsFactory)new PlatformMetricsFactoryImpl(metricsConfig), metricsConfig);
    }

    public static Metric getMetric(Metrics metrics, VirtualDataSource dataSource, String pattern) {
        return MerkleDbTestUtils.getMetric(metrics, dataSource, pattern, false);
    }

    public static Metric getMetric(Metrics metrics, VirtualDataSource dataSource, String pattern, boolean mayNotExist) {
        dataSource.registerMetrics(metrics);
        Optional<Metric> metric = metrics.getAll().stream().filter(it -> it.getName().contains(pattern)).findAny();
        if (!mayNotExist && metric.isEmpty()) {
            throw new IllegalStateException("unable to find statistic containing pattern " + pattern);
        }
        return metric.orElse(null);
    }

    public static void assertAllDatabasesClosed() {
        MerkleDbTestUtils.assertSomeDatabasesStillOpen(0L);
    }

    public static void assertSomeDatabasesStillOpen(@NonNull Long expectedOpenCount) {
        AssertionUtils.assertEventuallyEquals((Object)expectedOpenCount, MerkleDbDataSource::getCountOfOpenDatabases, (Duration)Duration.of(5L, ChronoUnit.SECONDS), (String)("Expected " + expectedOpenCount + " open databases."));
    }
}

