/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.MerkleTreeVisualizer;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.platform.state.PlatformStateAccessor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.hiero.base.crypto.Hash;

public class MerkleStateUtils {
    @NonNull
    public static String createInfoString(int hashDepth, @NonNull PlatformStateAccessor platformState, @NonNull Hash rootHash, @NonNull MerkleNode state) {
        Hash hashEventsCons = platformState.getLegacyRunningEventHash();
        ConsensusSnapshot snapshot = platformState.getSnapshot();
        List minimumJudgeInfo = snapshot == null ? null : snapshot.minimumJudgeInfoList();
        StringBuilder sb = new StringBuilder();
        new TextTable().setBordersEnabled(false).addRow(new Object[]{"Round:", platformState.getRound()}).addRow(new Object[]{"Timestamp:", platformState.getConsensusTimestamp()}).addRow(new Object[]{"Next consensus number:", snapshot == null ? "null" : Long.valueOf(snapshot.nextConsensusNumber())}).addRow(new Object[]{"Legacy running event hash:", hashEventsCons}).addRow(new Object[]{"Legacy running event mnemonic:", hashEventsCons == null ? "null" : Mnemonics.generateMnemonic((Hash)hashEventsCons)}).addRow(new Object[]{"Rounds non-ancient:", platformState.getRoundsNonAncient()}).addRow(new Object[]{"Creation version:", platformState.getCreationSoftwareVersion()}).addRow(new Object[]{"Minimum judge hash code:", minimumJudgeInfo == null ? "null" : Integer.valueOf(minimumJudgeInfo.hashCode())}).addRow(new Object[]{"Root hash:", rootHash}).addRow(new Object[]{"First BR Version:", platformState.getFirstVersionInBirthRoundMode()}).addRow(new Object[]{"Last round before BR:", platformState.getLastRoundBeforeBirthRoundMode()}).addRow(new Object[]{"Lowest Judge Gen before BR", platformState.getLowestJudgeGenerationBeforeBirthRoundMode()}).render(sb);
        sb.append("\n");
        new MerkleTreeVisualizer(state).setDepth(hashDepth).render(sb);
        return sb.toString();
    }
}

