/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.merkle.disk.OnDiskIterator;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.ReadableKVStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;

public final class OnDiskReadableKVState<K, V>
extends ReadableKVStateBase<K, V> {
    private final VirtualMap<OnDiskKey<K>, OnDiskValue<V>> virtualMap;
    private final long keyClassId;
    private final Codec<K> keyCodec;

    public OnDiskReadableKVState(String stateKey, long keyClassId, @Nullable Codec<K> keyCodec, @NonNull VirtualMap<OnDiskKey<K>, OnDiskValue<V>> virtualMap) {
        super(stateKey);
        this.keyClassId = keyClassId;
        this.keyCodec = keyCodec;
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        OnDiskKey<K> k = new OnDiskKey<K>(this.keyClassId, this.keyCodec, key);
        OnDiskValue v = (OnDiskValue)this.virtualMap.get(k);
        V value = v == null ? null : (V)v.getValue();
        StateLogger.logMapGet(this.getStateKey(), key, value);
        return value;
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        StateLogger.logMapIterate(this.getStateKey(), this.virtualMap);
        return new OnDiskIterator<K, V>(this.virtualMap);
    }

    @Deprecated
    public long size() {
        long size = this.virtualMap.size();
        StateLogger.logMapGetSize(this.getStateKey(), size);
        return size;
    }

    public void warm(@NonNull K key) {
        OnDiskKey<K> k = new OnDiskKey<K>(this.keyClassId, this.keyCodec, key);
        this.virtualMap.warm(k);
    }
}

