/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.permits;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.units.TimeUnit;
import com.swirlds.platform.gossip.permits.SyncPermitMetrics;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import org.hiero.base.CompareTo;

public class SyncPermitProvider {
    private int totalPermits;
    private final SyncConfig syncConfig;
    private int usedPermits;
    private final Time time;
    private boolean healthy;
    private Instant statusStartTime;
    private int revokedPermitsAccumulator;
    private double revokedPermitDelta;
    private double returnedPermitDelta;
    private int revokedPermits;
    private final double permitsRevokedPerSecond;
    private final double permitsReturnedPerSecond;
    private final Duration unhealthyGracePeriod;
    private int minimumUnrevokedPermitCount;
    private final SyncPermitMetrics metrics;

    public SyncPermitProvider(@NonNull PlatformContext platformContext, int totalPermits) {
        this.metrics = new SyncPermitMetrics(platformContext);
        this.time = platformContext.getTime();
        this.syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        this.permitsRevokedPerSecond = this.syncConfig.permitsRevokedPerSecond();
        this.permitsReturnedPerSecond = this.syncConfig.permitsReturnedPerSecond();
        this.unhealthyGracePeriod = this.syncConfig.unhealthyGracePeriod();
        this.setTotalPermits(totalPermits);
        this.healthy = true;
        this.statusStartTime = this.time.now();
    }

    public synchronized boolean acquire() {
        if (this.getAvailablePermits() > 0) {
            ++this.usedPermits;
            this.updateMetrics();
            return true;
        }
        return false;
    }

    public synchronized void reportUnhealthyDuration(@NonNull Duration duration) {
        if (CompareTo.isLessThan((Comparable)duration, (Object)this.unhealthyGracePeriod)) {
            if (!this.healthy) {
                this.computeRevokedPermits();
                this.healthy = true;
                this.statusStartTime = this.time.now();
                this.revokedPermitsAccumulator += (int)this.revokedPermitDelta;
                this.revokedPermitDelta = 0.0;
            }
        } else if (this.healthy) {
            this.computeRevokedPermits();
            this.healthy = false;
            this.statusStartTime = this.time.now();
            this.revokedPermitsAccumulator -= (int)this.returnedPermitDelta;
            this.returnedPermitDelta = 0.0;
        }
    }

    public synchronized void revokeAll() {
        this.returnedPermitDelta = 0.0;
        this.revokedPermitDelta = 0.0;
        this.revokedPermitsAccumulator = this.totalPermits;
        this.revokedPermits = this.totalPermits;
        this.statusStartTime = this.time.now();
        this.updateMetrics();
    }

    public synchronized void release() {
        if (this.usedPermits == 0) {
            throw new IllegalStateException("No permits to release");
        }
        --this.usedPermits;
        this.updateMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllPermitsToBeReleased() {
        while (true) {
            SyncPermitProvider syncPermitProvider = this;
            synchronized (syncPermitProvider) {
                if (this.usedPermits == 0) {
                    return;
                }
            }
            try {
                java.util.concurrent.TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("interrupted while waiting for all permits to be released", e);
            }
        }
    }

    private int getAvailablePermits() {
        this.computeRevokedPermits();
        return Math.max(0, this.totalPermits - this.usedPermits - this.revokedPermits);
    }

    private void computeRevokedPermits() {
        if (this.healthy) {
            if (this.revokedPermits == 0) {
                return;
            }
            Duration healthyDuration = Duration.between(this.statusStartTime, this.time.now());
            double healthySeconds = TimeUnit.UNIT_NANOSECONDS.convertTo(healthyDuration.toNanos(), TimeUnit.UNIT_SECONDS);
            this.returnedPermitDelta = Math.min((double)this.revokedPermitsAccumulator, healthySeconds * this.permitsReturnedPerSecond);
            if (this.returnedPermitDelta == (double)this.revokedPermitsAccumulator) {
                this.revokedPermitsAccumulator = 0;
                this.returnedPermitDelta = 0.0;
            }
        } else {
            if (this.revokedPermits == this.totalPermits) {
                return;
            }
            Duration unhealthyDuration = Duration.between(this.statusStartTime, this.time.now());
            double unhealthySeconds = TimeUnit.UNIT_NANOSECONDS.convertTo(unhealthyDuration.toNanos(), TimeUnit.UNIT_SECONDS);
            this.revokedPermitDelta = Math.min((double)this.totalPermits, unhealthySeconds * this.permitsRevokedPerSecond);
            if (this.revokedPermitDelta == (double)this.totalPermits) {
                this.revokedPermitsAccumulator = this.totalPermits;
                this.revokedPermitDelta = 0.0;
            }
        }
        int maximumRevokedCount = this.healthy ? this.totalPermits - this.minimumUnrevokedPermitCount : this.totalPermits;
        this.revokedPermits = Math.min(maximumRevokedCount, this.revokedPermitsAccumulator + (int)this.revokedPermitDelta - (int)this.returnedPermitDelta);
    }

    private void updateMetrics() {
        this.metrics.reportPermits(this.getAvailablePermits(), this.revokedPermits, this.usedPermits);
    }

    public synchronized void setTotalPermits(int totalPermits) {
        this.totalPermits = totalPermits;
        this.minimumUnrevokedPermitCount = Math.min(Math.max(totalPermits, 1), this.syncConfig.minimumHealthyUnrevokedPermitCount());
    }

    public synchronized void adjustTotalPermits(int permitsDifference) {
        this.setTotalPermits(Math.max(0, this.totalPermits + permitsDifference));
    }
}

