/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph;

import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.components.PrePaintableJPanel;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.hashgraph.internal.CachingGuiSource;
import com.swirlds.platform.gui.hashgraph.internal.HashgraphGuiControls;
import com.swirlds.platform.gui.hashgraph.internal.HashgraphPicture;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import javax.swing.JPanel;

public class HashgraphGui
extends PrePaintableJPanel {
    private static final long serialVersionUID = 1L;
    private final HashgraphPicture picturePanel;
    private final CachingGuiSource hashgraphSource;
    private final HashgraphGuiControls controls;
    private boolean sourceReadyCheckDone = false;

    public HashgraphGui(HashgraphGuiSource hashgraphSource) {
        this.hashgraphSource = new CachingGuiSource(hashgraphSource);
        this.controls = new HashgraphGuiControls(this::freezeChanged);
        JPanel checkboxesPanel = this.controls.createPanel();
        this.picturePanel = new HashgraphPicture(this.hashgraphSource, this.controls);
        this.picturePanel.setLayout(new GridBagLayout());
        this.picturePanel.setBackground(Color.WHITE);
        this.picturePanel.setVisible(true);
        JPanel pairPanel = GuiUtils.createPairPanel(checkboxesPanel, this.picturePanel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c4 = new GridBagConstraints();
        c4.anchor = 23;
        c4.gridx = 0;
        c4.gridy = 0;
        c4.weightx = 1.0;
        c4.weighty = 1.0;
        c4.gridwidth = 0;
        this.add((Component)pairPanel, c4);
        this.picturePanel.setVisible(true);
        Dimension ps = Toolkit.getDefaultToolkit().getScreenSize();
        ps.width -= 150;
        ps.height -= 200;
        pairPanel.setPreferredSize(ps);
        this.hashgraphSource.refresh();
        this.sourceReadyCheck();
        this.revalidate();
    }

    public void freezeChanged(ItemEvent e) {
        this.picturePanel.freezeChanged(e);
    }

    @Override
    public void prePaint() {
        this.reloadSource();
    }

    public void reloadSource() {
        this.sourceReadyCheck();
        if (!this.hashgraphSource.isReady() || this.controls.isPictureFrozen()) {
            return;
        }
        this.hashgraphSource.refresh();
    }

    private void sourceReadyCheck() {
        if (!this.sourceReadyCheckDone && this.hashgraphSource.isReady()) {
            this.sourceReadyCheckDone = true;
        }
    }
}

