/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.common.FastCopyable;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.serialize.KeySerializer;
import java.io.IOException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.NonCryptographicHashing;

public class ExampleLongLongKeyFixedSize
implements VirtualKey,
FastCopyable {
    private static final int CURRENT_SERIALIZATION_VERSION = 4685;
    private long value1;
    private long value2;

    public ExampleLongLongKeyFixedSize() {
    }

    public ExampleLongLongKeyFixedSize(long value) {
        this.value1 = value;
        this.value2 = Long.MAX_VALUE - value;
    }

    public ExampleLongLongKeyFixedSize(long value1, long value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    public long getValue() {
        return this.value1;
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32((long)this.value1, (long)this.value2);
    }

    public ExampleLongLongKeyFixedSize copy() {
        return new ExampleLongLongKeyFixedSize(this.value1, this.value2);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.value1);
        out.writeLong(this.value2);
    }

    public void deserialize(SerializableDataInputStream in, int dataVersion) throws IOException {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        this.value1 = in.readLong();
        this.value2 = in.readLong();
    }

    public long getClassId() {
        return 654838434445546360L;
    }

    public int getVersion() {
        return 4685;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExampleLongLongKeyFixedSize)) {
            return false;
        }
        ExampleLongLongKeyFixedSize that = (ExampleLongLongKeyFixedSize)o;
        return this.value1 == that.value1 && this.value2 == that.value2;
    }

    public long getValue1() {
        return this.value1;
    }

    public long getValue2() {
        return this.value2;
    }

    public String toString() {
        return "ExampleLongLongKeyFixedSize{value1=" + this.value1 + ", value2=" + this.value2 + "}";
    }

    public static class Serializer
    implements KeySerializer<ExampleLongLongKeyFixedSize> {
        private static final long CLASS_ID = -1265614491621468620L;

        public long getClassId() {
            return -1265614491621468620L;
        }

        public int getVersion() {
            return 1;
        }

        public int getSerializedSize() {
            return 16;
        }

        public long getCurrentDataVersion() {
            return 4685L;
        }

        public ExampleLongLongKeyFixedSize deserialize(ReadableSequentialData in) {
            long value1 = in.readLong();
            long value2 = in.readLong();
            return new ExampleLongLongKeyFixedSize(value1, value2);
        }

        public void serialize(ExampleLongLongKeyFixedSize data, WritableSequentialData out) {
            out.writeLong(data.getValue1());
            out.writeLong(data.getValue2());
        }

        public boolean equals(BufferedData buffer, ExampleLongLongKeyFixedSize keyToCompare) {
            long readValue1 = buffer.readLong();
            long readValue2 = buffer.readLong();
            return readValue1 == keyToCompare.getValue1() && readValue2 == keyToCompare.getValue2();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Serializer;
        }

        private static final class ClassVersion {
            public static final int ORIGINAL = 1;

            private ClassVersion() {
            }
        }
    }
}

