/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing.algorithms;

import com.swirlds.demo.stats.signing.algorithms.ExtendedSignature;
import com.swirlds.demo.stats.signing.algorithms.SigningAlgorithm;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.utility.CommonUtils;

public abstract class ECSigningAlgorithm
implements SigningAlgorithm {
    private static final Logger logger = LogManager.getLogger(ECSigningAlgorithm.class);
    private static final String EC_ALGORITHM_NAME = "EC";
    private final SignatureType signatureType;
    private KeyPair keyPair;
    private byte[] publicKeyBytes;
    private byte[] privateKeyBytes;
    private Signature signature;
    private SecureRandom random;
    private boolean algorithmAvailable;
    private MessageDigest keccakDigest;

    public ECSigningAlgorithm(SignatureType signatureType) {
        if (!EC_ALGORITHM_NAME.equals(signatureType.keyAlgorithm())) {
            throw new IllegalStateException("Illegal SignatureType Value: Not a DSA Implementation");
        }
        this.signatureType = signatureType;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKeyBytes;
    }

    @Override
    public byte[] getPrivateKey() {
        return this.privateKeyBytes;
    }

    @Override
    public byte[] sign(byte[] buffer, int offset, int len) throws SignatureException {
        try {
            byte[] dataHash = this.keccak256(buffer, offset, len);
            this.signature.initSign(this.keyPair.getPrivate(), this.random);
            this.signature.update(dataHash, 0, dataHash.length);
            return this.processSignature(this.signature.sign());
        }
        catch (IOException | InvalidKeyException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public ExtendedSignature signEx(byte[] buffer, int offset, int len) throws SignatureException {
        try {
            byte[] dataHash = this.keccak256(buffer, offset, len);
            this.signature.initSign(this.keyPair.getPrivate(), this.random);
            this.signature.update(dataHash, 0, dataHash.length);
            byte[] sig = this.signature.sign();
            return new ExtendedSignature(this.processSignature(sig), this.rawSignatureRCoord(sig), this.rawSignatureSCoord(sig));
        }
        catch (IOException | InvalidKeyException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public synchronized byte[] hash(byte[] buffer, int offset, int len) {
        return this.keccak256(buffer, offset, len);
    }

    @Override
    public void tryAcquirePrimitives() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.signatureType.keyAlgorithm(), this.signatureType.provider());
            this.random = new SecureRandom();
            keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(this.signatureType.ellipticalCurve()), this.random);
            this.keyPair = keyPairGenerator.generateKeyPair();
            this.publicKeyBytes = this.compressPublicKey(this.keyPair.getPublic());
            this.privateKeyBytes = this.keyPair.getPrivate().getEncoded();
            logger.trace(LogMarker.STARTUP.getMarker(), "Public Key Tracing [ signatureType = {}, key = {}, x = {}, y = {} ]", (Object)this.getSignatureType(), (Object)CommonUtils.hex((byte[])this.publicKeyBytes), (Object)CommonUtils.hex((byte[])this.rawPublicKeyXCoord(this.keyPair.getPublic())), (Object)CommonUtils.hex((byte[])this.rawPublicKeyYCoord(this.keyPair.getPublic())));
            this.signature = Signature.getInstance(this.signatureType.signingAlgorithm(), this.signatureType.provider());
            this.keccakDigest = MessageDigest.getInstance("KECCAK-256");
            this.algorithmAvailable = true;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Algorithm Disabled: Exception During Initialization [ id = {}, class = {} ]", (Object)this.getId(), (Object)this.getClass().getName(), (Object)e);
            this.algorithmAvailable = false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.algorithmAvailable;
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    protected byte[] processSignature(byte[] sig) throws IOException {
        try (ASN1InputStream stream = new ASN1InputStream(sig);){
            ASN1Sequence seq = (ASN1Sequence)stream.readObject();
            ASN1Integer rInt = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer sInt = (ASN1Integer)seq.getObjectAt(1);
            byte[] r = rInt.getValue().toByteArray();
            byte[] s = sInt.getValue().toByteArray();
            byte[] byArray = this.pointCompression(r, s);
            return byArray;
        }
    }

    protected byte[] rawSignatureRCoord(byte[] sig) throws IOException {
        try (ASN1InputStream stream = new ASN1InputStream(sig);){
            ASN1Sequence seq = (ASN1Sequence)stream.readObject();
            ASN1Integer rInt = (ASN1Integer)seq.getObjectAt(0);
            byte[] byArray = rInt.getValue().toByteArray();
            return byArray;
        }
    }

    protected byte[] rawSignatureSCoord(byte[] sig) throws IOException {
        try (ASN1InputStream stream = new ASN1InputStream(sig);){
            ASN1Sequence seq = (ASN1Sequence)stream.readObject();
            ASN1Integer sInt = (ASN1Integer)seq.getObjectAt(1);
            byte[] byArray = sInt.getValue().toByteArray();
            return byArray;
        }
    }

    protected byte[] compressPublicKey(PublicKey publicKey) {
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        ECPoint point = ecPublicKey.getQ();
        byte[] rawX = point.getRawXCoord().toBigInteger().toByteArray();
        byte[] rawY = point.getRawYCoord().toBigInteger().toByteArray();
        return this.pointCompression(rawX, rawY);
    }

    protected byte[] rawPublicKeyXCoord(PublicKey publicKey) {
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        ECPoint point = ecPublicKey.getQ();
        return point.getRawXCoord().toBigInteger().toByteArray();
    }

    protected byte[] rawPublicKeyYCoord(PublicKey publicKey) {
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        ECPoint point = ecPublicKey.getQ();
        return point.getRawYCoord().toBigInteger().toByteArray();
    }

    protected byte[] pointCompression(byte[] rawX, byte[] rawY) {
        byte[] rawComposite = new byte[this.getPublicKeyLength()];
        int deltaX = rawX.length - this.getCoordinateSize();
        int deltaY = rawY.length - this.getCoordinateSize();
        int srcStartX = Math.max(deltaX, 0);
        int srcStartY = Math.max(deltaY, 0);
        int lenX = rawX.length - srcStartX;
        int lenY = rawY.length - srcStartY;
        int dstStartX = this.getCoordinateSize() - lenX;
        int dstStartY = this.getCoordinateSize() + (this.getCoordinateSize() - lenY);
        System.arraycopy(rawX, srcStartX, rawComposite, dstStartX, lenX);
        System.arraycopy(rawY, srcStartY, rawComposite, dstStartY, lenY);
        return rawComposite;
    }

    protected byte[] keccak256(byte[] buffer, int offset, int len) {
        this.keccakDigest.reset();
        this.keccakDigest.update(buffer, offset, len);
        return this.keccakDigest.digest();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

