/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.swirlds.merkledb.test.fixtures.ExampleByteArrayVirtualValue;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class ExampleVariableSizeVirtualValue
extends ExampleByteArrayVirtualValue {
    private static final int RANDOM_BYTES = 1024;
    private static final byte[] RANDOM_DATA = new byte[1024];
    private static final Random RANDOM = new Random(12234L);
    public static final int SERIALIZATION_VERSION = 865;
    private int id;
    private byte[] data;

    public ExampleVariableSizeVirtualValue() {
    }

    public ExampleVariableSizeVirtualValue(int id) {
        this.id = id;
        this.data = new byte[256 + id % 768];
        System.arraycopy(RANDOM_DATA, 0, this.data, 0, this.data.length);
    }

    public ExampleVariableSizeVirtualValue(int id, byte[] data) {
        this.id = id;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public void deserialize(SerializableDataInputStream inputStream, int dataVersion) throws IOException {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        this.id = inputStream.readInt();
        int dataLength = inputStream.readInt();
        this.data = new byte[dataLength];
        inputStream.read(this.data);
    }

    public void serialize(SerializableDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.id);
        outputStream.writeInt(this.data.length);
        outputStream.write(this.data);
    }

    void serialize(ByteBuffer buffer) {
        buffer.putInt(this.id);
        buffer.putInt(this.data.length);
        buffer.put(this.data);
    }

    void deserialize(ByteBuffer buffer, int dataVersion) {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        this.id = buffer.getInt();
        int dataLength = buffer.getInt();
        assert (dataLength > 0) : "DataLength[" + dataLength + "] should never be 0 or less";
        this.data = new byte[dataLength];
        buffer.get(this.data);
    }

    public VirtualValue copy() {
        return this;
    }

    public VirtualValue asReadOnly() {
        return this;
    }

    public long getClassId() {
        return 846821551352L;
    }

    public int getVersion() {
        return 865;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExampleVariableSizeVirtualValue that = (ExampleVariableSizeVirtualValue)o;
        return this.id == that.id && Arrays.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.id);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public String toString() {
        return "ExampleVariableSizeVirtualValue{id=" + this.id + ", data=" + Arrays.toString(this.data) + "}";
    }

    static {
        RANDOM.nextBytes(RANDOM_DATA);
    }
}

