/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.WeightGenerator;
import com.swirlds.common.test.fixtures.WeightGenerators;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterBuilder;
import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusTestNode;
import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusTestOrchestrator;
import com.swirlds.platform.test.fixtures.consensus.framework.TestInput;
import com.swirlds.platform.test.fixtures.event.emitter.EventEmitter;
import com.swirlds.platform.test.fixtures.event.emitter.EventEmitterGenerator;
import com.swirlds.platform.test.fixtures.event.emitter.ShuffledEventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.StandardGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.event.source.StandardEventSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.base.utility.test.fixtures.ResettableRandom;

public class OrchestratorBuilder {
    private int numberOfNodes = 4;
    private WeightGenerator weightGenerator = WeightGenerators.BALANCED;
    private long seed = 0L;
    private int totalEventNum = 10000;
    private Function<List<Long>, List<EventSource>> eventSourceBuilder = null;
    private Consumer<EventSource> eventSourceConfigurator = es -> {};
    private PlatformContext platformContext;
    private EventEmitterGenerator node1EventEmitterGenerator = ShuffledEventEmitter::new;
    private EventEmitterGenerator node2EventEmitterGenerator = ShuffledEventEmitter::new;

    @NonNull
    public static OrchestratorBuilder builder() {
        return new OrchestratorBuilder();
    }

    @NonNull
    public OrchestratorBuilder setEventSourceBuilder(@NonNull Function<List<Long>, List<EventSource>> eventSourceBuilder) {
        this.eventSourceBuilder = eventSourceBuilder;
        return this;
    }

    @NonNull
    public OrchestratorBuilder setTestInput(@NonNull TestInput testInput) {
        this.numberOfNodes = testInput.numberOfNodes();
        this.weightGenerator = testInput.weightGenerator();
        this.seed = testInput.seed();
        this.totalEventNum = testInput.eventsToGenerate();
        this.platformContext = testInput.platformContext();
        return this;
    }

    @NonNull
    public OrchestratorBuilder setEventSourceConfigurator(@NonNull Consumer<EventSource> eventSourceConfigurator) {
        this.eventSourceConfigurator = eventSourceConfigurator;
        return this;
    }

    @NonNull
    public OrchestratorBuilder setNode1EventEmitterGenerator(@NonNull EventEmitterGenerator node1EventEmitterGenerator) {
        this.node1EventEmitterGenerator = node1EventEmitterGenerator;
        return this;
    }

    @NonNull
    public OrchestratorBuilder setNode2EventEmitterGenerator(@NonNull EventEmitterGenerator node2EventEmitterGenerator) {
        this.node2EventEmitterGenerator = node2EventEmitterGenerator;
        return this;
    }

    @NonNull
    public ConsensusTestOrchestrator build() {
        ResettableRandom random = RandomUtils.initRandom((Long)this.seed, (boolean)false);
        long graphSeed = random.nextLong();
        long shuffler1Seed = random.nextLong();
        long shuffler2Seed = random.nextLong();
        Roster roster = RandomRosterBuilder.create((Random)random).withSize(this.numberOfNodes).withWeightGenerator(this.weightGenerator).build();
        List<Long> weights = roster.rosterEntries().stream().map(RosterEntry::weight).toList();
        List<EventSource> eventSources = this.eventSourceBuilder != null ? this.eventSourceBuilder.apply(weights) : Stream.generate(() -> new StandardEventSource(false)).map(ses -> ses).limit(this.numberOfNodes).toList();
        for (EventSource eventSource : eventSources) {
            this.eventSourceConfigurator.accept(eventSource);
        }
        StandardGraphGenerator graphGenerator = new StandardGraphGenerator(this.platformContext, graphSeed, eventSources, roster);
        EventEmitter node1Emitter = this.node1EventEmitterGenerator.getEventEmitter(graphGenerator.cleanCopy(), shuffler1Seed);
        EventEmitter node2Emitter = this.node2EventEmitterGenerator.getEventEmitter(graphGenerator.cleanCopy(), shuffler2Seed);
        ArrayList<ConsensusTestNode> nodes = new ArrayList<ConsensusTestNode>();
        nodes.add(ConsensusTestNode.genesisContext(this.platformContext, node1Emitter));
        nodes.add(ConsensusTestNode.genesisContext(this.platformContext, node2Emitter));
        return new ConsensusTestOrchestrator(this.platformContext, nodes, weights, this.totalEventNum);
    }
}

