/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class OnDiskIterator<K, V>
implements Iterator<K> {
    private final MerkleIterator<MerkleNode> itr;
    private K next = null;

    public OnDiskIterator(@NonNull VirtualMap<OnDiskKey<K>, OnDiskValue<V>> virtualMap) {
        this.itr = Objects.requireNonNull(virtualMap).treeIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.itr.hasNext()) {
            VirtualLeafNode leaf;
            VirtualKey k;
            MerkleNode merkleNode = this.itr.next();
            if (!(merkleNode instanceof VirtualLeafNode) || !((k = (leaf = (VirtualLeafNode)merkleNode).getKey()) instanceof OnDiskKey)) continue;
            OnDiskKey onDiskKey = (OnDiskKey)k;
            this.next = onDiskKey.getKey();
            return true;
        }
        return false;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        K k = this.next;
        this.next = null;
        return k;
    }
}

