/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health;

import com.swirlds.platform.health.clock.OSClockSourceSpeedCheck;
import com.swirlds.platform.health.entropy.OSEntropyCheck;
import com.swirlds.platform.health.filesystem.OSFileSystemCheck;
import java.nio.file.Path;

public final class OSHealthCheckMain {
    private OSHealthCheckMain() {
    }

    public static void main(String[] args) {
        OSHealthCheckMain.printOSClockSpeedReport();
        OSHealthCheckMain.printOSEntropyReport();
        if (args.length > 0) {
            OSHealthCheckMain.printOSFileSystemReport(Path.of(args[0], new String[0]));
        }
    }

    private static void printOSFileSystemReport(Path fileToRead) {
        try {
            OSFileSystemCheck.Report report = OSFileSystemCheck.execute(fileToRead);
            if (report.code() == OSFileSystemCheck.TestResultCode.SUCCESS) {
                double elapsedMillis = (double)report.readNanos().longValue() * 1.0E-6;
                System.out.printf("File system check passed, took %d nanos (%s millis) to open the file and read 1 byte (data=%s)%n", report.readNanos(), elapsedMillis, report.data());
            } else if (report.exception() == null) {
                System.out.printf("File system check failed. Reason: %s%n", new Object[]{report.code()});
            } else {
                System.out.printf("File system check failed with exception. Reason: %s%n%s%n", new Object[]{report.code(), report.exception()});
            }
        }
        catch (InterruptedException e) {
            System.out.println("Thread interrupted while checking the file system");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static void printOSClockSpeedReport() {
        OSClockSourceSpeedCheck.Report clockSpeedReport = OSClockSourceSpeedCheck.execute();
        System.out.printf("Average clock source speed: %d calls/sec%n", clockSpeedReport.callsPerSec());
    }

    private static void printOSEntropyReport() {
        try {
            OSEntropyCheck.Report randomSpeed = OSEntropyCheck.execute();
            if (randomSpeed.success()) {
                double elapsedMillis = (double)randomSpeed.elapsedNanos().longValue() * 1.0E-6;
                System.out.printf("First random number generation time: %d nanos (%s millis), generated long=%d%n", randomSpeed.elapsedNanos(), elapsedMillis, randomSpeed.randomLong());
            } else {
                System.out.println("Random number generation check failed due to timeout");
            }
        }
        catch (InterruptedException e) {
            System.out.println("Thread interrupted while measuring the random number generation speed");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

