/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.TeacherSubtree;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.VirtualStateAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeResponse;
import com.swirlds.virtualmap.internal.reconnect.TeacherPullVirtualTreeReceiveTask;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class TeacherPullVirtualTreeView<K extends VirtualKey, V extends VirtualValue>
extends VirtualTreeViewBase<K, V>
implements TeacherTreeView<Long> {
    private static final Logger logger = LogManager.getLogger(TeacherPullVirtualTreeView.class);
    private final ReconnectConfig reconnectConfig;
    private RecordAccessor<K, V> records;
    private final CountDownLatch readyLatch = new CountDownLatch(1);
    private final AtomicBoolean ready = new AtomicBoolean(false);

    public TeacherPullVirtualTreeView(ThreadManager threadManager, ReconnectConfig reconnectConfig, VirtualRootNode<K, V> root, VirtualStateAccessor state, VirtualPipeline<K, V> pipeline) {
        super(root, state, state);
        this.reconnectConfig = reconnectConfig;
        ((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setRunnable(() -> {
            try {
                this.records = (RecordAccessor)pipeline.pausePipelineAndRun("copy", root::detach);
                this.ready.set(true);
            }
            finally {
                this.readyLatch.countDown();
            }
        }).setComponent("virtualmap")).setThreadName("detacher")).build().start();
    }

    public void startTeacherTasks(TeachingSynchronizer teachingSynchronizer, Time time, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream, Queue<TeacherSubtree> subtrees) {
        AsyncOutputStream out = teachingSynchronizer.buildOutputStream(workGroup, (SerializableDataOutputStream)outputStream);
        out.start();
        TeacherPullVirtualTreeReceiveTask teacherReceiveTask = new TeacherPullVirtualTreeReceiveTask(time, this.reconnectConfig, workGroup, (SerializableDataInputStream)inputStream, (AsyncOutputStream<PullVirtualTreeResponse>)out, this);
        teacherReceiveTask.exec();
    }

    private boolean isLeaf(long path) {
        return path >= this.reconnectState.getFirstLeafPath() && path <= this.reconnectState.getLastLeafPath();
    }

    public void writeNode(SerializableDataOutputStream out, long path, boolean isClean) throws IOException {
        this.checkValidNode(path, this.reconnectState);
        if (path == 0L) {
            out.writeLong(this.reconnectState.getFirstLeafPath());
            out.writeLong(this.reconnectState.getLastLeafPath());
        }
        if (!isClean && this.isLeaf(path) && this.reconnectState.getFirstLeafPath() > 0L) {
            out.writeSerializable(this.records.findLeafRecord(path, false), false);
        }
    }

    public Hash loadHash(long path) {
        return this.records.findHash(path);
    }

    public void waitUntilReady() throws InterruptedException {
        this.readyLatch.await();
        if (!this.ready.get()) {
            throw new RuntimeException("Failed to wait until teacher view is ready");
        }
    }

    public Long getRoot() {
        return 0L;
    }

    public void addToHandleQueue(Long node) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.addToHandleQueue()");
    }

    public Long getNextNodeToHandle() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.getNextNodeToHandle()");
    }

    public boolean areThereNodesToHandle() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.areThereNodesToHandle()");
    }

    public Long getChildAndPrepareForQueryResponse(Long parent, int childIndex) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.getChildAndPrepareForQueryResponse()");
    }

    public Long getNodeForNextResponse() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.getNodeForNextResponse()");
    }

    public boolean isResponseExpected() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.isResponseExpected()");
    }

    public void registerResponseForNode(Long node, boolean learnerHasNode) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.registerResponseForNode()");
    }

    public boolean hasLearnerConfirmedFor(Long node) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.hasLearnerConfirmedFor()");
    }

    public void serializeLeaf(SerializableDataOutputStream out, Long leaf) throws IOException {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.serializeLeaf()");
    }

    public void serializeInternal(SerializableDataOutputStream out, Long internal) throws IOException {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.serializeInternal()");
    }

    public void writeChildHashes(Long parent, SerializableDataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.writeChildHashes()");
    }

    public boolean isCustomReconnectRoot(Long node) {
        return node == 0L;
    }

    public void close() {
        try {
            this.waitUntilReady();
            this.records.getDataSource().close();
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "interrupted while attempting to close data source");
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to close data source properly", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

