/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.platform.state.PlatformStateModifier;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.base.crypto.Hash;

public class PlatformStateValueAccumulator
implements PlatformStateModifier {
    private long round = 0L;
    private boolean roundUpdated;
    private Hash legacyRunningEventHash;
    private boolean legacyRunningEventHashUpdated;
    private Instant consensusTimestamp;
    private boolean consensusTimestampUpdated;
    private SemanticVersion creationSoftwareVersion;
    private boolean creationSoftwareVersionUpdated;
    private int roundsNonAncient;
    private boolean roundsNonAncientUpdated;
    private ConsensusSnapshot snapshot;
    private boolean snapshotUpdated;
    private Instant freezeTime;
    private boolean freezeTimeUpdated;
    private long latestFreezeRound;
    private boolean latestFreezeRoundUpdated;
    private Instant lastFrozenTime;
    private boolean lastFrozenTimeUpdated;
    private SemanticVersion firstVersionInBirthRoundMode;
    private boolean firstVersionInBirthRoundModeUpdated;
    private long lastRoundBeforeBirthRoundMode = -1L;
    private boolean lastRoundBeforeBirthRoundModeUpdated;
    private long lowestJudgeGenerationBeforeBirthRoundMode = -1L;
    private boolean lowestJudgeGenerationBeforeBirthRoundModeUpdated;

    @Override
    @NonNull
    public SemanticVersion getCreationSoftwareVersion() {
        return this.creationSoftwareVersion;
    }

    @Override
    public void setCreationSoftwareVersion(@NonNull SemanticVersion creationVersion) {
        this.creationSoftwareVersion = Objects.requireNonNull(creationVersion);
        this.creationSoftwareVersionUpdated = true;
    }

    @Override
    public long getRound() {
        return this.round;
    }

    @Override
    public void setRound(long round) {
        this.round = round;
        this.roundUpdated = true;
    }

    @Override
    @Nullable
    public Hash getLegacyRunningEventHash() {
        return this.legacyRunningEventHash;
    }

    @Override
    public void setLegacyRunningEventHash(@Nullable Hash legacyRunningEventHash) {
        this.legacyRunningEventHash = legacyRunningEventHash;
        this.legacyRunningEventHashUpdated = true;
    }

    @Override
    @Nullable
    public Instant getConsensusTimestamp() {
        return this.consensusTimestamp;
    }

    @Override
    public void setConsensusTimestamp(@NonNull Instant consensusTimestamp) {
        this.consensusTimestamp = Objects.requireNonNull(consensusTimestamp);
        this.consensusTimestampUpdated = true;
    }

    @Override
    public long getAncientThreshold() {
        if (this.snapshot == null) {
            throw new IllegalStateException("No minimum judge info found in state for round " + this.round + ", snapshot is null");
        }
        List minimumJudgeInfo = this.snapshot.minimumJudgeInfoList();
        if (minimumJudgeInfo.isEmpty()) {
            throw new IllegalStateException("No minimum judge info found in state for round " + this.round + ", list is empty");
        }
        return ((MinimumJudgeInfo)minimumJudgeInfo.getFirst()).minimumJudgeAncientThreshold();
    }

    @Override
    public void setRoundsNonAncient(int roundsNonAncient) {
        this.roundsNonAncient = roundsNonAncient;
        this.roundsNonAncientUpdated = true;
    }

    @Override
    public int getRoundsNonAncient() {
        return this.roundsNonAncient;
    }

    @Override
    @Nullable
    public ConsensusSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void setSnapshot(@NonNull ConsensusSnapshot snapshot) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.snapshotUpdated = true;
    }

    @Override
    @Nullable
    public Instant getFreezeTime() {
        return this.freezeTime;
    }

    @Override
    public void setFreezeTime(@Nullable Instant freezeTime) {
        this.freezeTime = freezeTime;
        this.freezeTimeUpdated = true;
    }

    @Override
    @Nullable
    public Instant getLastFrozenTime() {
        return this.lastFrozenTime;
    }

    @Override
    public long getLatestFreezeRound() {
        return this.latestFreezeRound;
    }

    @Override
    public void setLastFrozenTime(@Nullable Instant lastFrozenTime) {
        this.lastFrozenTime = lastFrozenTime;
        this.lastFrozenTimeUpdated = true;
    }

    @Override
    public void setLatestFreezeRound(long latestFreezeRound) {
        this.latestFreezeRound = latestFreezeRound;
        this.latestFreezeRoundUpdated = true;
    }

    @Override
    @Nullable
    public SemanticVersion getFirstVersionInBirthRoundMode() {
        return this.firstVersionInBirthRoundMode;
    }

    @Override
    public void setFirstVersionInBirthRoundMode(SemanticVersion firstVersionInBirthRoundMode) {
        this.firstVersionInBirthRoundMode = firstVersionInBirthRoundMode;
        this.firstVersionInBirthRoundModeUpdated = true;
    }

    @Override
    public long getLastRoundBeforeBirthRoundMode() {
        return this.lastRoundBeforeBirthRoundMode;
    }

    @Override
    public void setLastRoundBeforeBirthRoundMode(long lastRoundBeforeBirthRoundMode) {
        this.lastRoundBeforeBirthRoundMode = lastRoundBeforeBirthRoundMode;
        this.lastRoundBeforeBirthRoundModeUpdated = true;
    }

    @Override
    public long getLowestJudgeGenerationBeforeBirthRoundMode() {
        return this.lowestJudgeGenerationBeforeBirthRoundMode;
    }

    @Override
    public void setLowestJudgeGenerationBeforeBirthRoundMode(long lowestJudgeGenerationBeforeBirthRoundMode) {
        this.lowestJudgeGenerationBeforeBirthRoundMode = lowestJudgeGenerationBeforeBirthRoundMode;
        this.lowestJudgeGenerationBeforeBirthRoundModeUpdated = true;
    }

    public boolean isRoundUpdated() {
        return this.roundUpdated;
    }

    public boolean isLegacyRunningEventHashUpdated() {
        return this.legacyRunningEventHashUpdated;
    }

    public boolean isConsensusTimestampUpdated() {
        return this.consensusTimestampUpdated;
    }

    public boolean isCreationSoftwareVersionUpdated() {
        return this.creationSoftwareVersionUpdated;
    }

    public boolean isRoundsNonAncientUpdated() {
        return this.roundsNonAncientUpdated;
    }

    public boolean isSnapshotUpdated() {
        return this.snapshotUpdated;
    }

    public boolean isFreezeTimeUpdated() {
        return this.freezeTimeUpdated;
    }

    public boolean isLastFrozenTimeUpdated() {
        return this.lastFrozenTimeUpdated;
    }

    public boolean isLatestFreezeRoundUpdated() {
        return this.latestFreezeRoundUpdated;
    }

    public boolean isFirstVersionInBirthRoundModeUpdated() {
        return this.firstVersionInBirthRoundModeUpdated;
    }

    public boolean isLastRoundBeforeBirthRoundModeUpdated() {
        return this.lastRoundBeforeBirthRoundModeUpdated;
    }

    public boolean isLowestJudgeGenerationBeforeBirthRoundModeUpdated() {
        return this.lowestJudgeGenerationBeforeBirthRoundModeUpdated;
    }

    @Override
    public void bulkUpdate(@NonNull Consumer<PlatformStateModifier> updater) {
        updater.accept(this);
    }
}

