/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.format;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class StackTracePrinter {
    private static final int MAX_STACK_TRACE_DEPTH = -1;
    public static final String LINE_SEPARATOR = System.lineSeparator();

    public static void print(@NonNull StringBuilder writer, @Nullable Throwable throwable) throws IOException {
        Set alreadyPrinted = Collections.newSetFromMap(new IdentityHashMap());
        alreadyPrinted.add(throwable);
        Throwable currentThrowable = throwable;
        StackTraceElement[] enclosingTrace = new StackTraceElement[]{};
        while (currentThrowable != null) {
            writer.append(currentThrowable.getClass().getName());
            writer.append(": ");
            writer.append(currentThrowable.getMessage());
            writer.append(LINE_SEPARATOR);
            StackTraceElement[] stackTrace = currentThrowable.getStackTrace();
            int m = stackTrace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && stackTrace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int skippedFrames = stackTrace.length - 1 - m;
            for (int i = 0; i <= m; ++i) {
                StackTraceElement stackTraceElement = stackTrace[i];
                String moduleName = stackTraceElement.getModuleName();
                String moduleVersion = stackTraceElement.getModuleVersion();
                String fileName = stackTraceElement.getFileName();
                writer.append("\tat ");
                if (moduleName != null) {
                    writer.append(moduleName);
                    if (moduleVersion != null) {
                        writer.append("@");
                        writer.append(moduleVersion);
                    }
                    writer.append("/");
                }
                writer.append(stackTraceElement.getClassName());
                writer.append(".");
                writer.append(stackTraceElement.getMethodName());
                if (fileName != null) {
                    writer.append("(");
                    writer.append(fileName);
                    writer.append(":");
                    writer.append(stackTraceElement.getLineNumber());
                    writer.append(")");
                } else {
                    writer.append("(Unknown Source)");
                }
                writer.append(LINE_SEPARATOR);
            }
            if (skippedFrames != 0) {
                writer.append("\t... ");
                writer.append(skippedFrames);
                writer.append(" more");
                writer.append(LINE_SEPARATOR);
            }
            Throwable cause = currentThrowable.getCause();
            enclosingTrace = stackTrace;
            if (cause != null) {
                writer.append("Caused by: ");
                if (!alreadyPrinted.add(cause)) {
                    writer.append("[CIRCULAR REFERENCE: ").append(cause).append("]");
                    currentThrowable = null;
                    continue;
                }
                currentThrowable = cause;
                continue;
            }
            currentThrowable = null;
        }
    }
}

