/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.hashgraph;

import com.hedera.hapi.node.state.roster.Roster;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.transaction.ConsensusTransaction;

public interface Round
extends Iterable<ConsensusEvent> {
    @Override
    @NonNull
    public Iterator<ConsensusEvent> iterator();

    public long getRoundNum();

    public boolean isEmpty();

    public int getEventCount();

    @NonNull
    public Roster getConsensusRoster();

    default public void forEachTransaction(Consumer<ConsensusTransaction> transactionConsumer) {
        for (ConsensusEvent event : this) {
            Iterator<ConsensusTransaction> transIt = event.consensusTransactionIterator();
            while (transIt.hasNext()) {
                transactionConsumer.accept(transIt.next());
            }
        }
    }

    default public void forEachEventTransaction(BiConsumer<ConsensusEvent, ConsensusTransaction> consumer) {
        for (ConsensusEvent event : this) {
            Iterator<ConsensusTransaction> transIt = event.consensusTransactionIterator();
            while (transIt.hasNext()) {
                consumer.accept(event, transIt.next());
            }
        }
    }

    @NonNull
    public Instant getConsensusTimestamp();
}

