/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stress;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.demo.stress.StressTestingToolConfig;
import com.swirlds.demo.stress.StressTestingToolConsensusStateEventHandler;
import com.swirlds.demo.stress.StressTestingToolState;
import com.swirlds.demo.stress.TransactionPool;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.Browser;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;

public class StressTestingToolMain
implements SwirldMain<StressTestingToolState> {
    private static final Logger logger = LogManager.getLogger(StressTestingToolMain.class);
    private static final SemanticVersion semanticVersion = SemanticVersion.newBuilder().major(1).build();
    long lastTPSMeasureTime = 0L;
    double toCreate = 0.0;
    private Platform platform;
    private TransactionPool transactionPool;
    private final StoppableThread transactionGenerator = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("demo")).setThreadName("transaction-generator")).setMaximumRate(50.0)).setWork(this::generateTransactions).build();
    private static final SpeedometerMetric.Config TRAN_SUBMIT_TPS_SPEED_CONFIG;
    private SpeedometerMetric transactionSubmitSpeedometer;
    private int tps_measure_window_milliseconds = 200;
    private double expectedTPS = 0.0;
    private static final long WINDOW_CALCULATION_CONST = 125000L;
    private static final int TPS_RAMP_UP_WINDOW_MILLISECONDS = 20000;
    private long rampUpStartTimeMilliSeconds = 0L;
    private StressTestingToolConfig config;

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch((String[])args);
    }

    @Nullable
    public List<Class<? extends Record>> getConfigDataTypes() {
        return List.of(StressTestingToolConfig.class);
    }

    public void init(@NonNull Platform platform, @NonNull NodeId id) {
        this.platform = platform;
        this.config = (StressTestingToolConfig)platform.getContext().getConfiguration().getConfigData(StressTestingToolConfig.class);
        this.expectedTPS = (double)this.config.transPerSecToCreate() / (double)platform.getRoster().rosterEntries().size();
        this.tps_measure_window_milliseconds = (int)(125000.0 / this.expectedTPS);
        this.transactionPool = new TransactionPool(this.config.transPoolSize(), this.config.bytesPerTrans());
        Metrics metrics = platform.getContext().getMetrics();
        this.transactionSubmitSpeedometer = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)TRAN_SUBMIT_TPS_SPEED_CONFIG);
    }

    public void run() {
        Thread shutdownHook = ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setDaemon(false)).setNodeId(this.platform.getSelfId())).setComponent("app")).setThreadName("demo_log_time_pulse")).setRunnable(() -> logger.debug(LogMarker.STARTUP.getMarker(), "Keepalive Event for Regression Timing")).build();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.transactionGenerator.start();
        try {
            while (true) {
                Thread.sleep(1000L);
                this.generateTransactions();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private synchronized void generateTransactions() {
        byte[] transaction;
        if (this.config == null) {
            return;
        }
        long now = System.nanoTime();
        int numCreated = 0;
        if (this.lastTPSMeasureTime == 0L) {
            this.lastTPSMeasureTime = now;
            this.rampUpStartTimeMilliSeconds = now / 1000000L;
            logger.info(LogMarker.STARTUP.getMarker(), "First time calling generateTransactions() Expected TPS per code is {}", (Object)this.expectedTPS);
            return;
        }
        long elapsedTime = now / 1000000L - this.rampUpStartTimeMilliSeconds;
        double rampUpTPS = elapsedTime < 20000L ? this.expectedTPS * (double)elapsedTime / 20000.0 : this.expectedTPS;
        if (((double)now - (double)this.lastTPSMeasureTime) * 0.001 > (double)this.tps_measure_window_milliseconds) {
            this.toCreate = ((double)now - (double)this.lastTPSMeasureTime) * 1.0E-9 * rampUpTPS;
            this.lastTPSMeasureTime = now;
        }
        while (!(this.toCreate < 1.0) && this.platform.createTransaction(transaction = this.transactionPool.transaction())) {
            ++numCreated;
            this.toCreate -= 1.0;
        }
        this.transactionSubmitSpeedometer.update((double)numCreated);
    }

    public StressTestingToolState newStateRoot() {
        StressTestingToolState state = new StressTestingToolState();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        return state;
    }

    public ConsensusStateEventHandler<StressTestingToolState> newConsensusStateEvenHandler() {
        return new StressTestingToolConsensusStateEventHandler();
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    public Bytes encodeSystemTransaction(@NonNull StateSignatureTransaction transaction) {
        return StateSignatureTransaction.PROTOBUF.toBytes((Object)transaction);
    }

    static {
        try {
            logger.info(LogMarker.STARTUP.getMarker(), "Registering StressTestingToolState with ConstructableRegistry");
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(StressTestingToolState.class, () -> new StressTestingToolState()));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
            logger.info(LogMarker.STARTUP.getMarker(), "StressTestingToolState is registered with ConstructableRegistry");
        }
        catch (ConstructableRegistryException e) {
            logger.error(LogMarker.STARTUP.getMarker(), "Failed to register StressTestingToolState", (Throwable)e);
            throw new RuntimeException(e);
        }
        TRAN_SUBMIT_TPS_SPEED_CONFIG = new SpeedometerMetric.Config("Debug:info", "tranSubTPS").withDescription("Transaction submitted TPS");
    }
}

