/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.trace.codec;

import com.hedera.hapi.block.stream.trace.ContractInitcode;
import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.EVMTraceData;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EVMTraceDataJsonCodec
implements JsonCodec<EVMTraceData> {
    @NonNull
    public EVMTraceData parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            List temp_initcodes = Collections.emptyList();
            List temp_contract_actions = Collections.emptyList();
            List temp_contract_slot_usages = Collections.emptyList();
            List temp_logs = Collections.emptyList();
            String temp_error_details = "";
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "initcodes": {
                        temp_initcodes = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ContractInitcode.JSON, (int)(maxDepth - 1));
                        continue block16;
                    }
                    case "contractActions": {
                        temp_contract_actions = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ContractAction.JSON, (int)(maxDepth - 1));
                        continue block16;
                    }
                    case "contractSlotUsages": {
                        temp_contract_slot_usages = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ContractSlotUsage.JSON, (int)(maxDepth - 1));
                        continue block16;
                    }
                    case "logs": {
                        temp_logs = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), EvmTransactionLog.JSON, (int)(maxDepth - 1));
                        continue block16;
                    }
                    case "errorDetails": {
                        temp_error_details = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new EVMTraceData(temp_initcodes, temp_contract_actions, temp_contract_slot_usages, temp_logs, temp_error_details);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull EVMTraceData data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (!data.initcodes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"initcodes", ContractInitcode.JSON, data.initcodes()));
        }
        if (!data.contractActions().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"contractActions", ContractAction.JSON, data.contractActions()));
        }
        if (!data.contractSlotUsages().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"contractSlotUsages", ContractSlotUsage.JSON, data.contractSlotUsages()));
        }
        if (!data.logs().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"logs", EvmTransactionLog.JSON, data.logs()));
        }
        if (data.errorDetails() != "") {
            fieldLines.add(JsonTools.field((String)"errorDetails", (String)data.errorDetails()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

