/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.platform.event.EventDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;

public record EventDescriptorWrapper(@NonNull EventDescriptor eventDescriptor, @NonNull Hash hash, @NonNull NodeId creator) {
    public static final long CLASS_ID = -9052771871267871386L;

    public EventDescriptorWrapper(@NonNull EventDescriptor eventDescriptor) {
        this(eventDescriptor, new Hash(eventDescriptor.hash()), NodeId.of(eventDescriptor.creatorNodeId()));
    }

    public long birthRound() {
        return this.eventDescriptor.birthRound();
    }

    @NonNull
    public String shortString() {
        return this.shortString(new StringBuilder()).toString();
    }

    @NonNull
    public StringBuilder shortString(@NonNull StringBuilder sb) {
        Objects.requireNonNull(sb).append('(').append("CR:").append(this.creator().id()).append(" ").append("H:").append(this.hash().toHex(6)).append(" ").append("G:").append(this.eventDescriptor().generation()).append(" ").append("BR:").append(this.eventDescriptor().birthRound()).append(')');
        return sb;
    }
}

