/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.stream;

import com.swirlds.logging.legacy.LogMarker;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.Signer;
import org.hiero.base.crypto.internal.DetRandomProvider;
import org.hiero.base.utility.CommonUtils;

public class StreamFileSigner
implements Signer {
    public static final String SIG_ALGORITHM = SignatureType.RSA.signingAlgorithm();
    public static final String SIG_PROVIDER = SignatureType.RSA.provider();
    static final String SIG_TYPE = SignatureType.RSA.keyAlgorithm();
    static final int SIG_KEY_SIZE_BITS = 3072;
    private static final Logger logger = LogManager.getLogger(StreamFileSigner.class);
    private static final Marker LOGM_OBJECT_STREAM = MarkerManager.getMarker((String)"OBJECT_STREAM");
    private static final Marker LOGM_EXCEPTION = MarkerManager.getMarker((String)"EXCEPTION");
    private static final int SEED = 2;
    private KeyPair sigKeyPair;

    public StreamFileSigner() {
        try {
            KeyPairGenerator sigKeyGen = KeyPairGenerator.getInstance(SIG_TYPE, SIG_PROVIDER);
            SecureRandom sigDetRandom = DetRandomProvider.getDetRandom();
            sigKeyGen.initialize(3072, sigDetRandom);
            sigDetRandom.setSeed(2L);
            this.sigKeyPair = sigKeyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate KeyPair", (Throwable)e);
            com.swirlds.common.utility.CommonUtils.tellUserConsolePopup((String)"ERROR", (String)"ERROR: This Java installation does not have the needed cryptography providers installed");
        }
    }

    public org.hiero.base.crypto.Signature sign(byte[] data) {
        try {
            Signature signature = Signature.getInstance(SIG_ALGORITHM, SIG_PROVIDER);
            signature.initSign(this.sigKeyPair.getPrivate());
            signature.update(data);
            byte[] result = signature.sign();
            if (result == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to sign data: signature is null");
            }
            logger.debug(LOGM_OBJECT_STREAM, "Generated signature: {}", new Supplier[]{() -> CommonUtils.hex((byte[])result)});
            return new org.hiero.base.crypto.Signature(SignatureType.RSA, result);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to sign data", (Throwable)e);
            return new org.hiero.base.crypto.Signature(SignatureType.RSA, new byte[SignatureType.RSA.signatureLength()]);
        }
    }

    public PublicKey getPublicKey() {
        return this.sigKeyPair.getPublic();
    }
}

