/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class VirtualLeafRecord<K extends VirtualKey, V extends VirtualValue>
implements SelfSerializable {
    private static final long CLASS_ID = 293002664819372644L;
    private volatile long path;
    private K key;
    private V value;

    public VirtualLeafRecord() {
        this.path = -1L;
    }

    public VirtualLeafRecord(long path, K key, V value) {
        this.path = path;
        this.key = key;
        this.value = value;
    }

    public VirtualLeafRecord<K, V> copy() {
        return new VirtualLeafRecord<K, VirtualValue>(this.path, this.key, this.value.copy());
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setPath(long path) {
        this.path = path;
    }

    public long getPath() {
        return this.path;
    }

    public void setValue(V value) {
        if (this.value != value) {
            this.value = value;
        }
    }

    public VirtualLeafBytes toBytes(KeySerializer<K> keySerializer, ValueSerializer<V> valueSerializer) {
        byte[] valueBytes;
        if (this.key == null) {
            throw new IllegalStateException("Leaf records with null keys should not be serialized");
        }
        byte[] keyBytes = new byte[keySerializer.getSerializedSize(this.key)];
        keySerializer.serialize(this.key, (WritableSequentialData)BufferedData.wrap((byte[])keyBytes));
        if (this.value != null) {
            valueBytes = new byte[valueSerializer.getSerializedSize(this.value)];
            valueSerializer.serialize(this.value, (WritableSequentialData)BufferedData.wrap((byte[])valueBytes));
        } else {
            valueBytes = null;
        }
        return new VirtualLeafBytes(this.path, Bytes.wrap((byte[])keyBytes), this.key.hashCode(), valueBytes != null ? Bytes.wrap((byte[])valueBytes) : null);
    }

    public long getClassId() {
        return 293002664819372644L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.path);
        out.writeSerializable(this.key, true);
        out.writeSerializable(this.value, true);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.path = in.readLong();
        this.key = (VirtualKey)in.readSerializable();
        this.value = (VirtualValue)in.readSerializable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualLeafRecord that = (VirtualLeafRecord)o;
        return this.path == that.path && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.key, this.value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", this.key).append("value", this.value).append("path", (Object)this.path).toString();
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

