/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface TokenServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "TokenService";
    public static final String FULL_NAME = "proto.TokenService";

    public TransactionResponse createToken(Transaction var1);

    public TransactionResponse updateToken(Transaction var1);

    public TransactionResponse mintToken(Transaction var1);

    public TransactionResponse burnToken(Transaction var1);

    public TransactionResponse deleteToken(Transaction var1);

    public TransactionResponse wipeTokenAccount(Transaction var1);

    public TransactionResponse freezeTokenAccount(Transaction var1);

    public TransactionResponse unfreezeTokenAccount(Transaction var1);

    public TransactionResponse grantKycToTokenAccount(Transaction var1);

    public TransactionResponse revokeKycFromTokenAccount(Transaction var1);

    public TransactionResponse associateTokens(Transaction var1);

    public TransactionResponse dissociateTokens(Transaction var1);

    public TransactionResponse updateTokenFeeSchedule(Transaction var1);

    public Response getTokenInfo(Query var1);

    public Response getTokenNftInfo(Query var1);

    public TransactionResponse pauseToken(Transaction var1);

    public TransactionResponse unpauseToken(Transaction var1);

    public TransactionResponse updateNfts(Transaction var1);

    public TransactionResponse rejectToken(Transaction var1);

    public TransactionResponse airdropTokens(Transaction var1);

    public TransactionResponse cancelAirdrop(Transaction var1);

    public TransactionResponse claimAirdrop(Transaction var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(TokenServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        TokenServiceMethod m = (TokenServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::createToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::updateToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::mintToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::burnToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::deleteToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 5 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::wipeTokenAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 6 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::freezeTokenAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 7 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::unfreezeTokenAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 8 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::grantKycToTokenAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 9 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::revokeKycFromTokenAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 10 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::associateTokens).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 11 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::dissociateTokens).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 12 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::updateTokenFeeSchedule).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 13 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getTokenInfo).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 14 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getTokenNftInfo).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 15 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::pauseToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 16 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::unpauseToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 17 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::updateNfts).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 18 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::rejectToken).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 19 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::airdropTokens).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 20 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::cancelAirdrop).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 21 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::claimAirdrop).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Transaction)Transaction.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Transaction)Transaction.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Query)Query.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Query)Query.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)TransactionResponse.JSON.toJSON((Object)reply));
        }
        return TransactionResponse.PROTOBUF.toBytes((Object)reply);
    }

    @NonNull
    private Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)Response.JSON.toJSON((Object)reply));
        }
        return Response.PROTOBUF.toBytes((Object)reply);
    }

    public static enum TokenServiceMethod implements ServiceInterface.Method
    {
        createToken,
        updateToken,
        mintToken,
        burnToken,
        deleteToken,
        wipeTokenAccount,
        freezeTokenAccount,
        unfreezeTokenAccount,
        grantKycToTokenAccount,
        revokeKycFromTokenAccount,
        associateTokens,
        dissociateTokens,
        updateTokenFeeSchedule,
        getTokenInfo,
        getTokenNftInfo,
        pauseToken,
        unpauseToken,
        updateNfts,
        rejectToken,
        airdropTokens,
        cancelAirdrop,
        claimAirdrop;

    }
}

