/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.Console;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.demo.stats.StatsDemoState;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.Browser;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.gui.SwirldsGui;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.NoOpConsensusStateEventHandler;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;

public class StatsDemoMain
implements SwirldMain<StatsDemoState> {
    private boolean headless = false;
    private int writePeriod = 3000;
    private int bytesPerTrans = 1;
    private int transPerEventMax = 2048;
    private int transPerSecToCreate = 100;
    private String path;
    private NodeId selfId;
    private Platform platform;
    private Console console = null;
    private Random random = new Random();
    private static final SemanticVersion semanticVersion = SemanticVersion.newBuilder().major(1).build();
    private final StoppableThread transactionGenerator;
    long lastEventTime = System.nanoTime();
    double toCreate = 0.0;

    public StatsDemoMain() {
        this.transactionGenerator = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("demo")).setThreadName("transaction-generator")).setMaximumRate(50.0)).setWork(this::generateTransactions).build();
    }

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch((String[])args);
    }

    private void write(String message, boolean newline) {
        this.path = System.getProperty("user.dir") + File.separator + "StatsDemo" + String.valueOf(this.selfId) + ".csv";
        try (BufferedWriter file = new BufferedWriter(new FileWriter(this.path, true));){
            if (newline) {
                file.write("\n");
            } else {
                file.write(message.trim().replaceAll(",", "") + ",");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.console != null) {
            this.console.out.print(newline ? "\n" : message);
        }
    }

    private void eraseFile() {
        this.path = System.getProperty("user.dir") + File.separator + "StatsDemo" + String.valueOf(this.selfId) + ".csv";
        try (BufferedWriter file = new BufferedWriter(new FileWriter(this.path, false));){
            file.write("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(String message) {
        this.write(message, false);
    }

    private void newline() {
        this.write("", true);
    }

    private synchronized void generateTransactions() {
        byte[] transaction = new byte[this.bytesPerTrans];
        long now = System.nanoTime();
        double tps = this.transPerSecToCreate / this.platform.getRoster().rosterEntries().size();
        int numCreated = 0;
        if (this.transPerSecToCreate > -1) {
            this.toCreate += ((double)now - (double)this.lastEventTime) * 1.0E-9 * tps;
        }
        this.lastEventTime = now;
        while (!(this.transPerSecToCreate > -1 && this.toCreate < 1.0 || this.transPerEventMax > -1 && numCreated >= this.transPerEventMax)) {
            this.random.nextBytes(transaction);
            if (!this.platform.createTransaction(transaction)) break;
            ++numCreated;
            this.toCreate -= 1.0;
        }
    }

    public void init(Platform platform, NodeId id) {
        this.platform = platform;
        this.selfId = id;
        String[] parameters = ParameterProvider.getInstance().getParameters();
        this.headless = parameters[0].equals("1");
        this.writePeriod = Integer.parseInt(parameters[1].replaceAll("_", ""));
        this.bytesPerTrans = Integer.parseInt(parameters[3].replaceAll("_", ""));
        this.transPerEventMax = Integer.parseInt(parameters[4].replaceAll("_", ""));
        this.transPerSecToCreate = Integer.parseInt(parameters[5].replaceAll("_", ""));
        if (this.transPerEventMax == -1 && this.transPerSecToCreate == -1) {
            this.transPerEventMax = 1024;
        }
        if (!this.headless) {
            int winNum = (int)this.selfId.id();
            this.console = SwirldsGui.createConsole((Platform)platform, (int)winNum, (boolean)true);
        }
    }

    public void run() {
        Metrics metrics = this.platform.getContext().getMetrics();
        List metricList = metrics.getAll().stream().toList();
        this.eraseFile();
        if (this.console != null) {
            StringBuilder builder = new StringBuilder();
            for (Metric metric : metricList) {
                String formatString = "%" + this.valueAsString(metric).length() + "s";
                builder.append(String.format(formatString, metric.getName()));
            }
            this.console.setHeading(String.valueOf(builder) + "\n");
        }
        this.write(String.format("%14s: ", "filename"));
        this.write(String.format("%s", this.path));
        this.newline();
        for (Metric metric : metricList) {
            this.write(String.format("%14s: ", metric.getName()));
            this.write(String.format("%s", metric.getDescription()));
            this.newline();
        }
        this.newline();
        this.write("");
        this.write("");
        for (Metric metric : metricList) {
            String formatString = "%" + this.valueAsString(metric).length() + "s";
            this.write(String.format(formatString, metric.getName()));
        }
        this.newline();
        this.transactionGenerator.start();
        while (true) {
            try {
                while (true) {
                    this.write("");
                    this.write("");
                    for (Metric metric : metricList) {
                        this.write(this.valueAsString(metric));
                    }
                    this.newline();
                    Thread.sleep(this.writePeriod);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private String valueAsString(Metric metric) {
        try {
            return String.format(Locale.US, metric.getFormat(), metric.get(Metric.ValueType.VALUE));
        }
        catch (IllegalFormatException e) {
            if (this.console != null) {
                this.console.out.println(e.getLocalizedMessage());
            }
            return "";
        }
    }

    @NonNull
    public StatsDemoState newStateRoot() {
        StatsDemoState state = new StatsDemoState();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        return state;
    }

    @NonNull
    public ConsensusStateEventHandler newConsensusStateEvenHandler() {
        return NoOpConsensusStateEventHandler.NO_OP_CONSENSUS_STATE_EVENT_HANDLER;
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    public Bytes encodeSystemTransaction(@NonNull StateSignatureTransaction transaction) {
        return StateSignatureTransaction.PROTOBUF.toBytes((Object)transaction);
    }

    static {
        try {
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(StatsDemoState.class, () -> {
                StatsDemoState statsDemoState = new StatsDemoState();
                return statsDemoState;
            }));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
    }
}

