/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.demo.migration.AccountID;
import com.swirlds.demo.migration.MapValue;
import com.swirlds.demo.migration.MigrationTestingToolState;
import com.swirlds.demo.migration.virtual.AccountVirtualMapKey;
import com.swirlds.demo.migration.virtual.AccountVirtualMapValue;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import java.util.Random;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class MigrationTestingToolTransaction
implements SelfSerializable {
    private static final long CLASS_ID = -892425423460273113L;
    private TransactionType type;
    private long seed;

    public MigrationTestingToolTransaction() {
    }

    public MigrationTestingToolTransaction(TransactionType type, long seed) {
        this.type = type;
        this.seed = seed;
    }

    public void applyTo(MigrationTestingToolState state) {
        Random random = new Random(this.seed);
        switch (this.type.ordinal()) {
            case 0: {
                this.applyMerkleMapTransaction(state, random);
                break;
            }
            case 1: {
                this.applyVirtualMapTransaction(state, random);
                break;
            }
            default: {
                throw new IllegalStateException("unhandled type " + String.valueOf((Object)this.type));
            }
        }
    }

    private void applyMerkleMapTransaction(MigrationTestingToolState state, Random random) {
        MerkleMap<AccountID, MapValue> map = state.getMerkleMap();
        AccountID key = new AccountID(0L, 0L, Math.abs(random.nextLong()));
        MapValue value = MapValue.generateRandom(random, key);
        map.put((Object)key, (MerkleNode)value);
    }

    private void applyVirtualMapTransaction(MigrationTestingToolState state, Random random) {
        VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> map = state.getVirtualMap();
        AccountVirtualMapKey key = new AccountVirtualMapKey(0L, 0L, Math.abs(random.nextLong()));
        AccountVirtualMapValue value = new AccountVirtualMapValue(random.nextLong(), random.nextLong(), random.nextLong(), random.nextBoolean(), random.nextLong());
        map.put((VirtualKey)key, (VirtualValue)value);
    }

    public long getClassId() {
        return -892425423460273113L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.type.ordinal());
        out.writeLong(this.seed);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.type = TransactionType.values()[in.readInt()];
        this.seed = in.readLong();
    }

    public int getVersion() {
        return 1;
    }

    public String toString() {
        return "MigrationTestingToolTransaction{type=" + String.valueOf((Object)this.type) + ", seed=" + this.seed + "}";
    }

    public static enum TransactionType {
        MERKLE_MAP,
        VIRTUAL_MAP;

    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

