/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDb;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.constructable.constructors.MerkleDbDataSourceBuilderConstructor;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@ConstructableClass(value=105533191404034088L, constructorType=MerkleDbDataSourceBuilderConstructor.class)
public class MerkleDbDataSourceBuilder
implements VirtualDataSourceBuilder {
    public static final long CLASS_ID = 105533191404034088L;
    private Path databaseDir;
    private MerkleDbTableConfig tableConfig;
    private final Configuration configuration;

    public MerkleDbDataSourceBuilder(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public MerkleDbDataSourceBuilder(MerkleDbTableConfig tableConfig, @NonNull Configuration configuration) {
        this(null, tableConfig, configuration);
    }

    public MerkleDbDataSourceBuilder(Path databaseDir, MerkleDbTableConfig tableConfig, @NonNull Configuration configuration) {
        this.databaseDir = databaseDir;
        this.tableConfig = tableConfig;
        this.configuration = Objects.requireNonNull(configuration);
    }

    @NonNull
    public VirtualDataSource build(String label, boolean withDbCompactionEnabled) {
        if (this.tableConfig == null) {
            throw new IllegalArgumentException("Table serialization config is missing");
        }
        MerkleDb database = MerkleDb.getInstance(this.databaseDir, this.configuration);
        try {
            return database.createDataSource(label, this.tableConfig, withDbCompactionEnabled);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @NonNull
    public MerkleDbDataSource copy(VirtualDataSource snapshotMe, boolean makeCopyActive, boolean offlineUse) {
        if (!(snapshotMe instanceof MerkleDbDataSource)) {
            throw new IllegalArgumentException("The datasource must be compatible with the MerkleDb");
        }
        MerkleDbDataSource source = (MerkleDbDataSource)snapshotMe;
        try {
            return source.getDatabase().copyDataSource(source, makeCopyActive, offlineUse);
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    public void snapshot(@NonNull Path destination, VirtualDataSource snapshotMe) {
        if (!(snapshotMe instanceof MerkleDbDataSource)) {
            throw new IllegalArgumentException("The datasource must be compatible with the MerkleDb");
        }
        MerkleDbDataSource source = (MerkleDbDataSource)snapshotMe;
        try {
            source.getDatabase().snapshot(destination, source);
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    @NonNull
    public VirtualDataSource restore(String label, Path source) {
        try {
            MerkleDb database = MerkleDb.restore(source, this.databaseDir, this.configuration);
            return database.getDataSource(label, true);
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    public long getClassId() {
        return 105533191404034088L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializable((SelfSerializable)this.tableConfig, false);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.tableConfig = (MerkleDbTableConfig)in.readSerializable(false, MerkleDbTableConfig::new);
    }

    public int hashCode() {
        return this.tableConfig.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MerkleDbDataSourceBuilder)) {
            return false;
        }
        MerkleDbDataSourceBuilder that = (MerkleDbDataSourceBuilder)obj;
        return Objects.equals(this.tableConfig, that.tableConfig);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

