/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.extendable.extensions;

import com.swirlds.common.io.extendable.InputStreamExtension;
import com.swirlds.common.io.extendable.OutputStreamExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.hiero.base.CompareTo;

public class ThrottleStreamExtension
implements InputStreamExtension,
OutputStreamExtension {
    private static final Duration DEFAULT_INCREMENT = Duration.ofMillis(100L);
    private long bytesInCurrentIncrement;
    private final Duration timeIncrement;
    private Instant currentIncrementStart;
    private final long bytesPerIncrement;
    private InputStream inputStream;
    private OutputStream outputStream;

    @Override
    public void init(InputStream baseStream) {
        this.inputStream = baseStream;
    }

    @Override
    public void init(OutputStream baseStream) {
        this.outputStream = baseStream;
    }

    public ThrottleStreamExtension(long bytesPerSecond) {
        this(bytesPerSecond, DEFAULT_INCREMENT);
    }

    public ThrottleStreamExtension(long bytesPerSecond, Duration timeIncrement) {
        this.timeIncrement = timeIncrement;
        this.bytesPerIncrement = (long)((double)bytesPerSecond * ((double)timeIncrement.toNanos() * 1.0E-9));
        this.currentIncrementStart = Instant.now();
        this.bytesInCurrentIncrement = this.bytesPerIncrement;
    }

    public int getAvailableCapacity(int requestedLength) {
        if (this.bytesInCurrentIncrement >= (long)requestedLength) {
            return requestedLength;
        }
        if (this.bytesInCurrentIncrement == 0L) {
            Instant now = Instant.now();
            Duration elapsed = Duration.between(this.currentIncrementStart, now);
            Duration remaining = this.timeIncrement.minus(elapsed);
            if (CompareTo.isGreaterThanOrEqualTo((Comparable)remaining, (Object)Duration.ZERO)) {
                try {
                    TimeUnit.MILLISECONDS.sleep(remaining.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.currentIncrementStart = now.plus(remaining.toMillis(), ChronoUnit.MILLIS);
            } else {
                this.currentIncrementStart = now;
            }
            this.bytesInCurrentIncrement = this.bytesPerIncrement;
            if (this.bytesInCurrentIncrement >= (long)requestedLength) {
                return requestedLength;
            }
            return (int)this.bytesInCurrentIncrement;
        }
        return (int)this.bytesInCurrentIncrement;
    }

    public void decrementCapacity(int length) {
        if (this.bytesInCurrentIncrement < (long)length) {
            throw new IllegalStateException("insufficient bytes in current increment");
        }
        this.bytesInCurrentIncrement -= (long)length;
    }

    @Override
    public int read() throws IOException {
        while (this.getAvailableCapacity(1) == 0) {
        }
        int aByte = this.inputStream.read();
        this.decrementCapacity(1);
        return aByte;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int allowedBytes = this.getAvailableCapacity(length);
        int read = this.inputStream.read(bytes, offset, allowedBytes);
        if (read == -1) {
            return -1;
        }
        this.decrementCapacity(read);
        return read;
    }

    @Override
    public byte[] readNBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        int bytesRead = this.readNBytes(bytes, 0, length);
        if (bytesRead < length) {
            byte[] shortBytes = new byte[bytesRead];
            System.arraycopy(bytes, 0, shortBytes, 0, bytesRead);
            return shortBytes;
        }
        return bytes;
    }

    @Override
    public int readNBytes(byte[] bytes, int offset, int length) throws IOException {
        int bytesRead;
        int read;
        for (bytesRead = 0; bytesRead < length; bytesRead += read) {
            int remainingLength = length - bytesRead;
            int currentOffset = offset + bytesRead;
            int allowedBytes = this.getAvailableCapacity(remainingLength);
            read = this.inputStream.readNBytes(bytes, currentOffset, allowedBytes);
            this.decrementCapacity(read);
            if (read >= allowedBytes) continue;
            break;
        }
        return bytesRead;
    }

    @Override
    public void write(int b) throws IOException {
        while (this.getAvailableCapacity(1) == 0) {
        }
        this.outputStream.write(b);
        this.decrementCapacity(1);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        int allowedBytes;
        for (int bytesWritten = 0; bytesWritten < length; bytesWritten += allowedBytes) {
            int remainingLength = length - bytesWritten;
            int currentOffset = offset + bytesWritten;
            allowedBytes = this.getAvailableCapacity(remainingLength);
            this.outputStream.write(bytes, currentOffset, allowedBytes);
            this.decrementCapacity(allowedBytes);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

