/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.crypto.internal;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.internal.MerkleInternalDigestProvider;
import com.swirlds.common.merkle.hash.MerkleHashBuilder;
import com.swirlds.logging.legacy.LogMarker;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.crypto.config.CryptoConfig;

public class MerkleCryptoEngine
implements MerkleCryptography {
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    private final MerkleInternalDigestProvider merkleInternalDigestProvider = new MerkleInternalDigestProvider();
    private final MerkleHashBuilder merkleHashBuilder;

    public MerkleCryptoEngine(CryptoConfig settings) {
        this.merkleHashBuilder = new MerkleHashBuilder(this, settings.computeCpuDigestThreadCount());
    }

    @Override
    public Hash digestTreeSync(MerkleNode root) {
        return this.merkleHashBuilder.digestTreeSync(root);
    }

    @Override
    public Future<Hash> digestTreeAsync(MerkleNode root) {
        return this.merkleHashBuilder.digestTreeAsync(root);
    }

    @Override
    public Hash digestSync(MerkleInternal node, List<Hash> childHashes, boolean setHash) {
        try {
            Hash hash = this.merkleInternalDigestProvider.compute(node, childHashes, Cryptography.DEFAULT_DIGEST_TYPE);
            if (setHash) {
                node.setHash(hash);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException((Throwable)e, LogMarker.EXCEPTION);
        }
    }

    @Override
    public Hash digestSync(MerkleInternal node, boolean setHash) {
        ArrayList<Hash> childHashes = new ArrayList<Hash>(node.getNumberOfChildren());
        for (int childIndex = 0; childIndex < node.getNumberOfChildren(); ++childIndex) {
            MerkleNode child = node.getChild(childIndex);
            if (child == null) {
                childHashes.add(Cryptography.NULL_HASH);
                continue;
            }
            childHashes.add(child.getHash());
        }
        return this.digestSync(node, childHashes, setHash);
    }

    @Override
    public Hash digestSync(MerkleLeaf leaf) {
        return CRYPTOGRAPHY.digestSync((SerializableHashable)leaf);
    }
}

