/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.AccountIDJsonCodec;
import com.hedera.hapi.node.base.codec.AccountIDProtoCodec;
import com.hedera.hapi.node.base.schema.AccountIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class AccountID {
    public static final Codec<AccountID> PROTOBUF = new AccountIDProtoCodec();
    public static final JsonCodec<AccountID> JSON = new AccountIDJsonCodec();
    public static final AccountID DEFAULT = AccountID.newBuilder().build();
    private final long shardNum;
    private final long realmNum;
    private final OneOf<AccountOneOfType> account;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public AccountID(long shardNum, long realmNum, OneOf<AccountOneOfType> account) {
        this.$unknownFields = null;
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        if (account == null) {
            throw new NullPointerException("Parameter 'account' must be supplied and can not be null");
        }
        this.account = account;
    }

    public AccountID(long shardNum, long realmNum, OneOf<AccountOneOfType> account, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        if (account == null) {
            throw new NullPointerException("Parameter 'account' must be supplied and can not be null");
        }
        this.account = account;
    }

    public long shardNum() {
        return this.shardNum;
    }

    public long realmNum() {
        return this.realmNum;
    }

    public OneOf<AccountOneOfType> account() {
        return this.account;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountIDSchema.SHARD_NUM, (long)this.shardNum, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountIDSchema.REALM_NUM, (long)this.realmNum, (boolean)true);
            if (this.account.kind() == AccountOneOfType.ACCOUNT_NUM) {
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountIDSchema.ACCOUNT_NUM, (long)((Long)this.account.as()), (boolean)true);
            }
            if (this.account.kind() == AccountOneOfType.ALIAS) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountIDSchema.ALIAS, (RandomAccessData)((RandomAccessData)this.account.as()), (boolean)true);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.shardNum != AccountID.DEFAULT.shardNum) {
                result = 31 * result + Long.hashCode(this.shardNum);
            }
            if (this.realmNum != AccountID.DEFAULT.realmNum) {
                result = 31 * result + Long.hashCode(this.realmNum);
            }
            if (this.account != null && !this.account.equals(AccountID.DEFAULT.account)) {
                result = 31 * result + this.account.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AccountID thatObj = (AccountID)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.shardNum != thatObj.shardNum) {
            return false;
        }
        if (this.realmNum != thatObj.realmNum) {
            return false;
        }
        if (this.account == null && thatObj.account != null) {
            return false;
        }
        if (this.account != null && !this.account.equals(thatObj.account)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "AccountID[shardNum=" + this.shardNum + ", realmNum=" + this.realmNum + ", account=" + String.valueOf(this.account) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Long accountNum() {
        return this.account.kind() == AccountOneOfType.ACCOUNT_NUM ? (Long)this.account.value() : null;
    }

    public boolean hasAccountNum() {
        return this.account.kind() == AccountOneOfType.ACCOUNT_NUM;
    }

    public Long accountNumOrElse(@NonNull Long defaultValue) {
        return this.hasAccountNum() ? this.accountNum() : defaultValue;
    }

    @NonNull
    public Long accountNumOrThrow() {
        return Objects.requireNonNull(this.accountNum(), "Field accountNum is null");
    }

    @Nullable
    public Bytes alias() {
        return this.account.kind() == AccountOneOfType.ALIAS ? (Bytes)this.account.value() : null;
    }

    public boolean hasAlias() {
        return this.account.kind() == AccountOneOfType.ALIAS;
    }

    public Bytes aliasOrElse(@NonNull Bytes defaultValue) {
        return this.hasAlias() ? this.alias() : defaultValue;
    }

    @NonNull
    public Bytes aliasOrThrow() {
        return Objects.requireNonNull(this.alias(), "Field alias is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.shardNum, this.realmNum, this.account, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum AccountOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        ACCOUNT_NUM(3, "accountNum"),
        ALIAS(4, "alias");

        private final int protoOrdinal;
        private final String protoName;

        private AccountOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static AccountOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 3 -> ACCOUNT_NUM;
                case 4 -> ALIAS;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static AccountOneOfType fromString(String name) {
            return switch (name) {
                case "accountNum", "ACCOUNT_NUM" -> ACCOUNT_NUM;
                case "alias", "ALIAS" -> ALIAS;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private long shardNum = 0L;
        private long realmNum = 0L;
        private OneOf<AccountOneOfType> account = AccountIDProtoCodec.ACCOUNT_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long shardNum, long realmNum, OneOf<AccountOneOfType> account) {
            this.$unknownFields = null;
            this.shardNum = shardNum;
            this.realmNum = realmNum;
            this.account = account;
        }

        public Builder(long shardNum, long realmNum, OneOf<AccountOneOfType> account, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.shardNum = shardNum;
            this.realmNum = realmNum;
            this.account = account;
        }

        public AccountID build() {
            return new AccountID(this.shardNum, this.realmNum, this.account);
        }

        public Builder shardNum(long shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public Builder realmNum(long realmNum) {
            this.realmNum = realmNum;
            return this;
        }

        public Builder accountNum(long accountNum) {
            this.account = new OneOf((Enum)AccountOneOfType.ACCOUNT_NUM, (Object)accountNum);
            return this;
        }

        public Builder alias(@NonNull Bytes alias) {
            this.account = new OneOf((Enum)AccountOneOfType.ALIAS, (Object)alias);
            return this;
        }
    }
}

