/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing.algorithms;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.interfaces.Sign;
import com.swirlds.demo.stats.signing.algorithms.ExtendedSignature;
import com.swirlds.demo.stats.signing.algorithms.SigningAlgorithm;
import com.swirlds.logging.legacy.LogMarker;
import java.security.SignatureException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.utility.CommonUtils;

public class X25519SigningAlgorithm
implements SigningAlgorithm {
    private static final byte ALGORITHM_ID = 1;
    private static final Logger logger = LogManager.getLogger(X25519SigningAlgorithm.class);
    private static final int SIGNATURE_LENGTH = 64;
    private static final int PUBLIC_KEY_LENGTH = 32;
    private static final int PRIVATE_KEY_LENGTH = 64;
    private static final int ED_COORD_SIZE = 32;
    private Sign.Native signer;
    private byte[] publicKey;
    private byte[] privateKey;
    private boolean algorithmAvailable;

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public byte[] sign(byte[] buffer, int offset, int len) throws SignatureException {
        byte[] data;
        byte[] sig = new byte[64];
        if (offset != 0 || len != buffer.length) {
            int newSize = buffer.length - offset;
            data = new byte[newSize];
            System.arraycopy(buffer, offset, data, 0, data.length);
        } else {
            data = buffer;
        }
        if (!this.signer.cryptoSignDetached(sig, data, (long)data.length, this.privateKey)) {
            throw new SignatureException();
        }
        return sig;
    }

    @Override
    public ExtendedSignature signEx(byte[] buffer, int offset, int len) throws SignatureException {
        byte[] sig = this.sign(buffer, offset, len);
        byte[] r = Arrays.copyOfRange(sig, 0, 32);
        byte[] s = Arrays.copyOfRange(sig, 32, sig.length);
        return new ExtendedSignature(sig, r, s);
    }

    @Override
    public byte[] hash(byte[] buffer, int offset, int len) {
        throw new UnsupportedOperationException("External hashing is not supported by this algorithm");
    }

    @Override
    public void tryAcquirePrimitives() {
        try {
            SodiumJava sodium = new SodiumJava();
            this.signer = new LazySodiumJava(sodium);
            this.publicKey = new byte[32];
            this.privateKey = new byte[64];
            this.algorithmAvailable = this.signer.cryptoSignKeypair(this.publicKey, this.privateKey);
            logger.trace(LogMarker.STARTUP.getMarker(), "Public Key Tracing [ signatureType = {}, key = {} ]", (Object)this.getSignatureType(), (Object)CommonUtils.hex((byte[])this.publicKey));
        }
        catch (Exception e) {
            logger.warn(LogMarker.EXCEPTION.getMarker(), "Algorithm Disabled: Exception During Initialization [ id = {}, class = {} ]", (Object)this.getId(), (Object)this.getClass().getName(), (Object)e);
            this.algorithmAvailable = false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.algorithmAvailable;
    }

    @Override
    public int getSignatureLength() {
        return 64;
    }

    @Override
    public int getPublicKeyLength() {
        return 32;
    }

    @Override
    public int getCoordinateSize() {
        return 32;
    }

    @Override
    public SignatureType getSignatureType() {
        return SignatureType.ED25519;
    }
}

