/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
extends AnnotationBasedArgumentsProvider<MethodSource> {
    private static final Predicate<Method> isFactoryMethod = method -> CollectionUtils.isConvertibleToStream(method.getReturnType()) && !MethodArgumentsProvider.isTestMethod(method);

    MethodArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, MethodSource methodSource) {
        Class testClass = context.getRequiredTestClass();
        Method testMethod = context.getRequiredTestMethod();
        Object testInstance = context.getTestInstance().orElse(null);
        String[] methodNames = methodSource.value();
        return Arrays.stream(methodNames).map(factoryMethodName -> MethodArgumentsProvider.findFactoryMethod(testClass, testMethod, factoryMethodName)).map(factoryMethod -> MethodArgumentsProvider.validateFactoryMethod(factoryMethod, testInstance)).map(factoryMethod -> context.getExecutableInvoker().invoke(factoryMethod, testInstance)).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private static Method findFactoryMethod(Class<?> testClass, Method testMethod, String factoryMethodName) {
        String originalFactoryMethodName = factoryMethodName;
        if (StringUtils.isBlank((String)factoryMethodName)) {
            factoryMethodName = testMethod.getName();
            return MethodArgumentsProvider.findFactoryMethodBySimpleName(testClass, testMethod, factoryMethodName);
        }
        if (!MethodArgumentsProvider.looksLikeAFullyQualifiedMethodName(factoryMethodName)) {
            factoryMethodName = testClass.getName() + "#" + factoryMethodName;
        }
        Method factoryMethod = MethodArgumentsProvider.findFactoryMethodByFullyQualifiedName(testClass, testMethod, factoryMethodName);
        Preconditions.condition((boolean)isFactoryMethod.test(factoryMethod), () -> String.format("Could not find valid factory method [%s] for test class [%s] but found the following invalid candidate: %s", originalFactoryMethodName, testClass.getName(), factoryMethod));
        return factoryMethod;
    }

    private static boolean looksLikeAFullyQualifiedMethodName(String factoryMethodName) {
        if (factoryMethodName.contains("#")) {
            return true;
        }
        int indexOfFirstDot = factoryMethodName.indexOf(46);
        if (indexOfFirstDot == -1) {
            return false;
        }
        int indexOfLastOpeningParenthesis = factoryMethodName.lastIndexOf(40);
        if (indexOfLastOpeningParenthesis > 0) {
            return indexOfFirstDot < indexOfLastOpeningParenthesis;
        }
        return true;
    }

    static Method findFactoryMethodByFullyQualifiedName(Class<?> testClass, Method testMethod, String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(testClass);
        Class<?> clazz = MethodArgumentsProvider.loadRequiredClass(className, classLoader);
        Method factoryMethod = ReflectionUtils.findMethod(clazz, (String)methodName, (String)methodParameters).orElse(null);
        if (factoryMethod != null) {
            return factoryMethod;
        }
        boolean explicitParameterListSpecified = StringUtils.isNotBlank((String)methodParameters) || fullyQualifiedMethodName.endsWith("()");
        Preconditions.condition((!explicitParameterListSpecified ? 1 : 0) != 0, () -> String.format("Could not find factory method [%s(%s)] in class [%s]", methodName, methodParameters, className));
        return MethodArgumentsProvider.findFactoryMethodBySimpleName(clazz, testMethod, methodName);
    }

    private static Method findFactoryMethodBySimpleName(Class<?> clazz, Method testMethod, String factoryMethodName) {
        Predicate<Method> isCandidate = candidate -> factoryMethodName.equals(candidate.getName()) && !testMethod.equals(candidate);
        List candidates = ReflectionUtils.findMethods(clazz, isCandidate);
        List factoryMethods = candidates.stream().filter(isFactoryMethod).collect(Collectors.toList());
        Preconditions.condition((factoryMethods.size() > 0 ? 1 : 0) != 0, () -> {
            if (candidates.size() > 0) {
                return String.format("Could not find valid factory method [%s] in class [%s] but found the following invalid candidates: %s", factoryMethodName, clazz.getName(), candidates);
            }
            return String.format("Could not find factory method [%s] in class [%s]", factoryMethodName, clazz.getName());
        });
        Preconditions.condition((factoryMethods.size() == 1 ? 1 : 0) != 0, () -> String.format("%d factory methods named [%s] were found in class [%s]: %s", factoryMethods.size(), factoryMethodName, clazz.getName(), factoryMethods));
        return (Method)factoryMethods.get(0);
    }

    private static boolean isTestMethod(Method candidate) {
        return AnnotationUtils.isAnnotated((AnnotatedElement)candidate, Test.class) || AnnotationUtils.isAnnotated((AnnotatedElement)candidate, TestTemplate.class) || AnnotationUtils.isAnnotated((AnnotatedElement)candidate, TestFactory.class);
    }

    private static Class<?> loadRequiredClass(String className, ClassLoader classLoader) {
        return (Class)ReflectionUtils.tryToLoadClass((String)className, (ClassLoader)classLoader).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private static Method validateFactoryMethod(Method factoryMethod, Object testInstance) {
        Preconditions.condition((factoryMethod.getDeclaringClass().isInstance(testInstance) || ReflectionUtils.isStatic((Member)factoryMethod) ? 1 : 0) != 0, () -> String.format("Method '%s' must be static: local factory methods must be static unless the PER_CLASS @TestInstance lifecycle mode is used; external factory methods must always be static.", factoryMethod.toGenericString()));
        return factoryMethod;
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray((Object)item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

