/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.memory;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.merkle.memory.InMemoryKey;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.spi.WritableKVStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public final class InMemoryWritableKVState<K, V>
extends WritableKVStateBase<K, V> {
    private final MerkleMap<InMemoryKey<K>, InMemoryValue<K, V>> merkle;
    private final Codec<K> keyCodec;
    private final Codec<V> valueCodec;
    private final long inMemoryValueClassId;

    public InMemoryWritableKVState(@NonNull String stateKey, long inMemoryValueClassId, @Nullable Codec<K> keyCodec, @NonNull Codec<V> valueCodec, @NonNull MerkleMap<InMemoryKey<K>, InMemoryValue<K, V>> merkleMap) {
        super(stateKey);
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
        this.inMemoryValueClassId = inMemoryValueClassId;
        this.merkle = Objects.requireNonNull(merkleMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        InMemoryKey<K> k = new InMemoryKey<K>(key);
        InMemoryValue leaf = (InMemoryValue)this.merkle.get(k);
        V value = leaf == null ? null : (V)leaf.getValue();
        StateLogger.logMapGet(this.getStateKey(), key, value);
        return value;
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        Set keySet = this.merkle.keySet();
        StateLogger.logMapIterate(this.getStateKey(), keySet);
        return keySet.stream().map(InMemoryKey::key).iterator();
    }

    protected void putIntoDataSource(@NonNull K key, @NonNull V value) {
        InMemoryKey<K> k = new InMemoryKey<K>(key);
        this.merkle.put(k, new InMemoryValue<K, V>(this.inMemoryValueClassId, this.keyCodec, this.valueCodec, k, value));
        StateLogger.logMapPut(this.getStateKey(), key, value);
    }

    protected void removeFromDataSource(@NonNull K key) {
        InMemoryKey<K> k = new InMemoryKey<K>(key);
        InMemoryValue removed = (InMemoryValue)this.merkle.remove(k);
        StateLogger.logMapRemove(this.getStateKey(), key, removed);
    }

    public long sizeOfDataSource() {
        int size = this.merkle.size();
        StateLogger.logMapGetSize(this.getStateKey(), size);
        return size;
    }
}

