/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.GossipController;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.permits.SyncPermitProvider;
import com.swirlds.platform.gossip.shadowgraph.Shadowgraph;
import com.swirlds.platform.gossip.shadowgraph.ShadowgraphSynchronizer;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.gossip.sync.protocol.SyncPeerProtocol;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.protocol.Protocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class SyncProtocol
implements Protocol,
GossipController {
    private static final Logger logger = LogManager.getLogger(SyncProtocol.class);
    private final PlatformContext platformContext;
    private final ShadowgraphSynchronizer synchronizer;
    private final FallenBehindManager fallenBehindManager;
    private final SyncPermitProvider permitProvider;
    private final IntakeEventCounter intakeEventCounter;
    private final AtomicBoolean gossipHalted = new AtomicBoolean(false);
    private final Duration sleepAfterSync;
    private final SyncMetrics syncMetrics;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);
    private volatile boolean started;

    public SyncProtocol(@NonNull PlatformContext platformContext, @NonNull ShadowgraphSynchronizer synchronizer, @NonNull FallenBehindManager fallenBehindManager, @NonNull IntakeEventCounter intakeEventCounter, @NonNull Duration sleepAfterSync, @NonNull SyncMetrics syncMetrics, int rosterSize) {
        SyncConfig syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        int permitCount = syncConfig.onePermitPerPeer() ? rosterSize - 1 : syncConfig.syncProtocolPermitCount();
        this.permitProvider = new SyncPermitProvider(platformContext, permitCount);
        this.platformContext = Objects.requireNonNull(platformContext);
        this.synchronizer = Objects.requireNonNull(synchronizer);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.sleepAfterSync = Objects.requireNonNull(sleepAfterSync);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
    }

    public static SyncProtocol create(@NonNull PlatformContext platformContext, @NonNull FallenBehindManager fallenBehindManager, @NonNull Consumer<PlatformEvent> receivedEventHandler, @NonNull IntakeEventCounter intakeEventCounter, @NonNull ThreadManager threadManager, int rosterSize) {
        CachedPoolParallelExecutor shadowgraphExecutor = new CachedPoolParallelExecutor(threadManager, "node-sync");
        SyncMetrics syncMetrics = new SyncMetrics(platformContext.getMetrics());
        Shadowgraph shadowgraph = new Shadowgraph(platformContext, rosterSize, intakeEventCounter);
        ShadowgraphSynchronizer syncShadowgraphSynchronizer = new ShadowgraphSynchronizer(platformContext, shadowgraph, rosterSize, syncMetrics, receivedEventHandler, fallenBehindManager, intakeEventCounter, (ParallelExecutor)shadowgraphExecutor);
        return new SyncProtocol(platformContext, syncShadowgraphSynchronizer, fallenBehindManager, intakeEventCounter, Duration.ZERO, syncMetrics, rosterSize);
    }

    @Override
    @NonNull
    public SyncPeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        return new SyncPeerProtocol(this.platformContext, Objects.requireNonNull(peerId), this.synchronizer, this.fallenBehindManager, this.permitProvider, this.intakeEventCounter, this.gossipHalted::get, this.sleepAfterSync, this.syncMetrics, this.platformStatus::get);
    }

    public void clear() {
        this.synchronizer.clear();
    }

    public void addEvent(@NonNull PlatformEvent platformEvent) {
        this.synchronizer.addEvent(platformEvent);
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.synchronizer.updateEventWindow(eventWindow);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Gossip already started");
        }
        this.started = true;
        this.synchronizer.start();
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        logger.info(LogMarker.FREEZE.getMarker(), "Gossip frozen, reason: stopping gossip");
        this.gossipHalted.set(true);
        this.permitProvider.waitForAllPermitsToBeReleased();
        this.synchronizer.stop();
    }

    @Override
    public void pause() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.gossipHalted.set(true);
        this.permitProvider.waitForAllPermitsToBeReleased();
    }

    @Override
    public void resume() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.intakeEventCounter.reset();
        this.gossipHalted.set(false);
        this.permitProvider.revokeAll();
    }

    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.permitProvider.reportUnhealthyDuration(duration);
    }

    public void adjustTotalPermits(int permitsDifference) {
        this.permitProvider.adjustTotalPermits(permitsDifference);
    }

    @VisibleForTesting
    SyncPermitProvider getPermitProvider() {
        return this.permitProvider;
    }
}

