/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.ReadableKVStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class MapReadableKVState<K, V>
extends ReadableKVStateBase<K, V> {
    private final Map<K, V> backingStore;

    public MapReadableKVState(@NonNull String stateKey, @NonNull Map<K, V> backingStore) {
        super(stateKey);
        this.backingStore = Objects.requireNonNull(backingStore);
    }

    protected V readFromDataSource(@NonNull K key) {
        return this.backingStore.get(key);
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        return this.backingStore.keySet().iterator();
    }

    public long size() {
        return this.backingStore.size();
    }

    @NonNull
    public static <K, V> Builder<K, V> builder(@NonNull String stateKey) {
        return new Builder(stateKey);
    }

    public static final class Builder<K, V> {
        private final Map<K, V> backingStore = new HashMap();
        private final String stateKey;

        Builder(@NonNull String stateKey) {
            this.stateKey = stateKey;
        }

        @NonNull
        public Builder<K, V> value(@NonNull K key, @Nullable V value) {
            this.backingStore.put(key, value);
            return this;
        }

        @NonNull
        public MapReadableKVState<K, V> build() {
            return new MapReadableKVState<K, V>(this.stateKey, new HashMap<K, V>(this.backingStore));
        }
    }
}

