/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.DefaultPlatformMetrics;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.PlatformMetricsFactoryImpl;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.merkledb.MerkleDb;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.merkledb.MerkleDbStatistics;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.test.fixtures.ExampleByteArrayVirtualValue;
import com.swirlds.merkledb.test.fixtures.ExampleFixedSizeVirtualValue;
import com.swirlds.merkledb.test.fixtures.ExampleFixedSizeVirtualValueSerializer;
import com.swirlds.merkledb.test.fixtures.ExampleLongKeyFixedSize;
import com.swirlds.merkledb.test.fixtures.ExampleLongKeyVariableSize;
import com.swirlds.merkledb.test.fixtures.ExampleLongLongKeyFixedSize;
import com.swirlds.merkledb.test.fixtures.ExampleLongLongKeyVariableSize;
import com.swirlds.merkledb.test.fixtures.ExampleVariableSizeVirtualValue;
import com.swirlds.merkledb.test.fixtures.ExampleVariableSizeVirtualValueSerializer;
import com.swirlds.merkledb.test.fixtures.MerkleDbTestUtils;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.hiero.base.crypto.DigestType;
import org.hiero.consensus.model.node.NodeId;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public enum TestType {
    fixed_fixed(true),
    fixed_variable(false),
    fixedComplex_fixed(true),
    fixedComplex_variable(false),
    variable_fixed(false),
    variable_variable(false),
    variableComplex_fixed(false),
    variableComplex_variable(false);

    public final boolean fixedSize;
    private Metrics metrics = null;

    private TestType(boolean fixedSize) {
        this.fixedSize = fixedSize;
    }

    public <K extends VirtualKey, V extends VirtualValue> DataTypeConfig<K, V> dataType() {
        return new DataTypeConfig(this);
    }

    public Metrics getMetrics() {
        if (this.metrics == null) {
            Configuration CONFIGURATION = new TestConfigBuilder().getOrCreateConfig();
            MetricsConfig metricsConfig = (MetricsConfig)CONFIGURATION.getConfigData(MetricsConfig.class);
            MetricKeyRegistry registry = (MetricKeyRegistry)Mockito.mock(MetricKeyRegistry.class);
            Mockito.when((Object)registry.register((NodeId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn((Object)true);
            this.metrics = new DefaultPlatformMetrics(null, registry, (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class), (PlatformMetricsFactory)new PlatformMetricsFactoryImpl(metricsConfig), metricsConfig);
            MerkleDbStatistics statistics = new MerkleDbStatistics((MerkleDbConfig)CONFIGURATION.getConfigData(MerkleDbConfig.class), "test");
            statistics.registerMetrics(this.metrics);
        }
        return this.metrics;
    }

    public class DataTypeConfig<K extends VirtualKey, V extends VirtualValue> {
        private final TestType testType;
        private final KeySerializer<? extends VirtualKey> keySerializer;
        private final ValueSerializer<? extends ExampleByteArrayVirtualValue> valueSerializer;

        public DataTypeConfig(TestType testType) {
            this.testType = testType;
            this.keySerializer = this.createKeySerializer();
            this.valueSerializer = this.createValueSerializer();
        }

        public KeySerializer<? extends VirtualKey> getKeySerializer() {
            return this.keySerializer;
        }

        public ValueSerializer<? extends ExampleByteArrayVirtualValue> getValueSerializer() {
            return this.valueSerializer;
        }

        private KeySerializer<? extends VirtualKey> createKeySerializer() {
            switch (this.testType.ordinal()) {
                default: {
                    return new ExampleLongKeyFixedSize.Serializer();
                }
                case 2: 
                case 3: {
                    return new ExampleLongLongKeyFixedSize.Serializer();
                }
                case 4: 
                case 5: {
                    return new ExampleLongKeyVariableSize.Serializer();
                }
                case 6: 
                case 7: 
            }
            return new ExampleLongLongKeyVariableSize.Serializer();
        }

        private ValueSerializer<? extends ExampleByteArrayVirtualValue> createValueSerializer() {
            switch (this.testType.ordinal()) {
                default: {
                    return new ExampleFixedSizeVirtualValueSerializer();
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
            }
            return new ExampleVariableSizeVirtualValueSerializer();
        }

        public VirtualKey createVirtualLongKey(int i) {
            switch (this.testType.ordinal()) {
                default: {
                    return new ExampleLongKeyFixedSize(i);
                }
                case 2: 
                case 3: {
                    return new ExampleLongLongKeyFixedSize(i);
                }
                case 4: 
                case 5: {
                    return new ExampleLongKeyVariableSize(i);
                }
                case 6: 
                case 7: 
            }
            return new ExampleLongLongKeyVariableSize(i);
        }

        public ExampleByteArrayVirtualValue createVirtualValue(int i) {
            switch (this.testType.ordinal()) {
                default: {
                    return new ExampleFixedSizeVirtualValue(i);
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
            }
            return new ExampleVariableSizeVirtualValue(i);
        }

        public long getDataFileLowLevelTestFileSize() {
            switch (this.testType.ordinal()) {
                default: 
            }
            return 24576L;
        }

        public boolean hasKeyToPathStore() {
            return this.keySerializer.getSerializedSize() != 8;
        }

        public MerkleDbDataSource createDataSource(Path dbPath, String name, int size, long hashesRamToDiskThreshold, boolean enableMerging, boolean preferDiskBasedIndexes) throws IOException {
            MerkleDb database = MerkleDb.getInstance((Path)dbPath, (Configuration)MerkleDbTestUtils.CONFIGURATION);
            MerkleDbTableConfig tableConfig = new MerkleDbTableConfig(1, DigestType.SHA_384, (long)size, hashesRamToDiskThreshold);
            MerkleDbDataSource dataSource = database.createDataSource(name, tableConfig, enableMerging);
            dataSource.registerMetrics(TestType.this.getMetrics());
            return dataSource;
        }

        public MerkleDbDataSource getDataSource(Path dbPath, String name, boolean enableMerging) throws IOException {
            MerkleDb database = MerkleDb.getInstance((Path)dbPath, (Configuration)MerkleDbTestUtils.CONFIGURATION);
            return database.getDataSource(name, enableMerging);
        }

        public VirtualHashRecord createVirtualInternalRecord(int i) {
            return new VirtualHashRecord((long)i, MerkleDbTestUtils.hash(i));
        }

        public VirtualLeafRecord<VirtualKey, ExampleByteArrayVirtualValue> createVirtualLeafRecord(int i) {
            return this.createVirtualLeafRecord(i, i, i);
        }

        public VirtualLeafRecord<VirtualKey, ExampleByteArrayVirtualValue> createVirtualLeafRecord(long path, int i, int valueIndex) {
            switch (this.testType.ordinal()) {
                default: {
                    return new VirtualLeafRecord(path, this.createVirtualLongKey(i), (VirtualValue)new ExampleFixedSizeVirtualValue(valueIndex));
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
            }
            return new VirtualLeafRecord(path, this.createVirtualLongKey(i), (VirtualValue)new ExampleVariableSizeVirtualValue(valueIndex));
        }
    }
}

