/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.demo.stats.signing.StatsSigningTestingToolConsensusStateEventHandler;
import com.swirlds.demo.stats.signing.StatsSigningTestingToolState;
import com.swirlds.demo.stats.signing.SttTransactionPool;
import com.swirlds.demo.stats.signing.algorithms.ECSecP256K1Algorithm;
import com.swirlds.demo.stats.signing.algorithms.X25519SigningAlgorithm;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.Browser;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;

public class StatsSigningTestingToolMain
implements SwirldMain<StatsSigningTestingToolState> {
    public static final byte SYSTEM_TRANSACTION_MARKER = 0;
    private static final Logger logger = LogManager.getLogger(StatsSigningTestingToolMain.class);
    long lastTPSMeasureTime = 0L;
    double toCreate = 0.0;
    private boolean headless = false;
    private int bytesPerTrans = 100;
    private int transPerEventMax = 2048;
    private int transPerSecToCreate = 100;
    private int signedTransPoolSize = 1024;
    private Platform platform;
    private SttTransactionPool sttTransactionPool;
    private static final SemanticVersion semanticVersion;
    private final StoppableThread transactionGenerator = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("demo")).setThreadName("transaction-generator")).setMaximumRate(50.0)).setWork(this::generateTransactions).build();
    private static final SpeedometerMetric.Config TRAN_SUBMIT_TPS_SPEED_CONFIG;
    private SpeedometerMetric transactionSubmitSpeedometer;
    private int tps_measure_window_milliseconds = 200;
    private double expectedTPS = 0.0;
    private static final long WINDOW_CALCULATION_CONST = 125000L;
    private static final int TPS_RAMP_UP_WINDOW_MILLISECONDS = 20000;
    private long rampUpStartTimeMilliSeconds = 0L;

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch((String[])args);
    }

    public void init(Platform platform, NodeId id) {
        this.platform = platform;
        String[] parameters = ParameterProvider.getInstance().getParameters();
        this.headless = parameters[0].equals("1");
        this.bytesPerTrans = Integer.parseInt(parameters[3].replaceAll("_", ""));
        this.transPerEventMax = Integer.parseInt(parameters[4].replaceAll("_", ""));
        this.transPerSecToCreate = Integer.parseInt(parameters[5].replaceAll("_", ""));
        this.expectedTPS = (double)this.transPerSecToCreate / (double)platform.getRoster().rosterEntries().size();
        this.tps_measure_window_milliseconds = (int)(125000.0 / this.expectedTPS);
        if (parameters.length > 6) {
            this.signedTransPoolSize = Integer.parseInt(parameters[6].replaceAll("_", ""));
        }
        if (this.transPerEventMax == -1 && this.transPerSecToCreate == -1) {
            this.transPerEventMax = 1024;
        }
        this.sttTransactionPool = new SttTransactionPool(platform.getSelfId(), this.signedTransPoolSize, this.bytesPerTrans, true, new ECSecP256K1Algorithm(), new X25519SigningAlgorithm());
        Metrics metrics = platform.getContext().getMetrics();
        this.transactionSubmitSpeedometer = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)TRAN_SUBMIT_TPS_SPEED_CONFIG);
    }

    public void run() {
        Thread shutdownHook = ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setDaemon(false)).setNodeId(this.platform.getSelfId())).setComponent("app")).setThreadName("demo_log_time_pulse")).setRunnable(() -> {
            Logger logger = LogManager.getLogger(this.getClass());
            logger.debug(LogMarker.STARTUP.getMarker(), "Keepalive Event for Regression Timing");
        }).build();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.transactionGenerator.start();
        try {
            while (true) {
                Thread.sleep(1000L);
                this.generateTransactions();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private synchronized void generateTransactions() {
        byte[] transaction;
        long now = System.nanoTime();
        int numCreated = 0;
        if (this.lastTPSMeasureTime == 0L) {
            this.lastTPSMeasureTime = now;
            this.rampUpStartTimeMilliSeconds = now / 1000000L;
            logger.info(LogMarker.STARTUP.getMarker(), "First time calling generateTransactions() Expected TPS per code is {}", (Object)this.expectedTPS);
            return;
        }
        if (this.transPerSecToCreate > -1) {
            long elapsedTime = now / 1000000L - this.rampUpStartTimeMilliSeconds;
            double rampUpTPS = 0.0;
            rampUpTPS = elapsedTime < 20000L ? this.expectedTPS * (double)elapsedTime / 20000.0 : this.expectedTPS;
            if (((double)now - (double)this.lastTPSMeasureTime) * 0.001 > (double)this.tps_measure_window_milliseconds) {
                this.toCreate = ((double)now - (double)this.lastTPSMeasureTime) * 1.0E-9 * rampUpTPS;
                this.lastTPSMeasureTime = now;
            }
        }
        while (!(this.transPerSecToCreate > -1 && this.toCreate < 1.0 || this.transPerEventMax > -1 && numCreated >= this.transPerEventMax || !this.platform.createTransaction(transaction = this.sttTransactionPool.transaction()))) {
            ++numCreated;
            this.toCreate -= 1.0;
        }
        this.transactionSubmitSpeedometer.update((double)numCreated);
    }

    @NonNull
    public StatsSigningTestingToolState newStateRoot() {
        StatsSigningTestingToolState state = new StatsSigningTestingToolState();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        return state;
    }

    public ConsensusStateEventHandler<StatsSigningTestingToolState> newConsensusStateEvenHandler() {
        return new StatsSigningTestingToolConsensusStateEventHandler(() -> this.sttTransactionPool);
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    @NonNull
    public Bytes encodeSystemTransaction(@NonNull StateSignatureTransaction transaction) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        WritableStreamingData out = new WritableStreamingData((OutputStream)bytes);
        out.writeByte((byte)0);
        try {
            StateSignatureTransaction.PROTOBUF.write((Object)transaction, (WritableSequentialData)out);
            return Bytes.wrap((byte[])bytes.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to encode a system transaction.", e);
        }
    }

    static {
        try {
            logger.info(LogMarker.STARTUP.getMarker(), "Registering StatsSigningTestingToolState with ConstructableRegistry");
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(StatsSigningTestingToolState.class, () -> {
                StatsSigningTestingToolState statsSigningTestingToolState = new StatsSigningTestingToolState();
                return statsSigningTestingToolState;
            }));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
            logger.info(LogMarker.STARTUP.getMarker(), "StatsSigningTestingToolState is registered with ConstructableRegistry");
        }
        catch (ConstructableRegistryException e) {
            logger.error(LogMarker.STARTUP.getMarker(), "Failed to register StatsSigningTestingToolState", (Throwable)e);
            throw new RuntimeException(e);
        }
        semanticVersion = SemanticVersion.newBuilder().major(1).build();
        TRAN_SUBMIT_TPS_SPEED_CONFIG = new SpeedometerMetric.Config("Debug:info", "tranSubTPS").withDescription("Transaction submitted TPS");
    }
}

