/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.crypto.Hash;

@ConstructableIgnored
public final class VirtualInternalNode<K extends VirtualKey, V extends VirtualValue>
extends PartialBinaryMerkleInternal
implements MerkleInternal,
VirtualNode {
    private static final int NUMBER_OF_CHILDREN = 2;
    public static final long CLASS_ID = -5826388714229745985L;
    public static final int SERIALIZATION_VERSION = 1;
    private final VirtualRootNode<K, V> root;
    private final VirtualHashRecord virtualHashRecord;

    public VirtualInternalNode(VirtualRootNode<K, V> root, VirtualHashRecord virtualHashRecord) {
        this.root = Objects.requireNonNull(root);
        this.virtualHashRecord = Objects.requireNonNull(virtualHashRecord);
        this.setHash(virtualHashRecord.hash());
    }

    public int getNumberOfChildren() {
        return 2;
    }

    public <T extends MerkleNode> T getChild(int i) {
        VirtualNode node;
        if (i == 0) {
            node = this.getLeft();
        } else if (i == 1) {
            node = this.getRight();
        } else {
            return null;
        }
        if (node == null) {
            return null;
        }
        long targetPath = node.getPath();
        List<Integer> routePath = Path.getRouteStepsFromRoot(targetPath);
        MerkleRoute nodeRoute = this.root.getRoute().extendRoute(routePath);
        node.setRoute(nodeRoute);
        return (T)node;
    }

    public void setChild(int index, MerkleNode merkleNode) {
        throw new UnsupportedOperationException();
    }

    public void setChild(int index, MerkleNode merkleNode, MerkleRoute merkleRoute, boolean mayBeImmutable) {
        throw new UnsupportedOperationException();
    }

    protected void updateChildRoutes(MerkleRoute route) {
    }

    public VirtualNode getLeft() {
        return this.getChild(Path.getLeftChildPath(this.virtualHashRecord.path()));
    }

    public VirtualNode getRight() {
        return this.getChild(Path.getRightChildPath(this.virtualHashRecord.path()));
    }

    private VirtualNode getChild(long childPath) {
        if (childPath < this.root.getState().getFirstLeafPath()) {
            return this.getInternalNode(childPath);
        }
        return this.getLeafNode(childPath);
    }

    private VirtualInternalNode<K, V> getInternalNode(long path) {
        assert (path != -1L) : "Cannot happen. Path will be a child of virtual record path every time.";
        assert (path < this.root.getState().getFirstLeafPath());
        Hash hash = this.root.getCache().lookupHashByPath(path, false);
        if (hash == null) {
            try {
                hash = this.root.getDataSource().loadHash(path);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a internal record from the data source", ex);
            }
        }
        VirtualHashRecord rec = new VirtualHashRecord(path, (Hash)(hash != VirtualNodeCache.DELETED_HASH ? hash : null));
        return new VirtualInternalNode<K, V>(this.root, rec);
    }

    private VirtualLeafNode<K, V> getLeafNode(long path) {
        Hash hash;
        assert (path != -1L);
        assert (path != 0L);
        if (path < this.root.getState().getFirstLeafPath() || path > this.root.getState().getLastLeafPath()) {
            return null;
        }
        VirtualLeafRecord<K, V> rec = this.root.getCache().lookupLeafByPath(path, false);
        if (rec == null) {
            try {
                VirtualLeafBytes leafBytes = this.root.getDataSource().loadLeafRecord(path);
                if (leafBytes == null) {
                    throw new IllegalStateException("Attempted to read from disk but couldn't find the leaf");
                }
                rec = leafBytes.toRecord(this.root.getKeySerializer(), this.root.getValueSerializer());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read a leaf record from the data source", ex);
            }
        }
        if ((hash = this.root.getCache().lookupHashByPath(path, false)) == null) {
            try {
                hash = this.root.getDataSource().loadHash(path);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a hash from the data source", ex);
            }
        }
        return new VirtualLeafNode<K, V>(rec, hash);
    }

    public VirtualInternalNode<K, V> copy() {
        throw new UnsupportedOperationException("Don't use this. Need a map pointer.");
    }

    public long getClassId() {
        return -5826388714229745985L;
    }

    public int getVersion() {
        return 1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.virtualHashRecord).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualInternalNode)) {
            return false;
        }
        VirtualInternalNode that = (VirtualInternalNode)o;
        return this.virtualHashRecord.equals(that.virtualHashRecord);
    }

    public int hashCode() {
        return Objects.hash(this.virtualHashRecord);
    }

    @Override
    public long getPath() {
        return this.virtualHashRecord.path();
    }
}

