/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.merkle.VirtualMapStatistics;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;

public class ReconnectHashLeafFlusher<K extends VirtualKey, V extends VirtualValue> {
    private static final Logger logger = LogManager.getLogger(ReconnectHashLeafFlusher.class);
    private volatile long firstLeafPath = 0L;
    private volatile long lastLeafPath = 0L;
    private final KeySerializer<K> keySerializer;
    private final ValueSerializer<V> valueSerializer;
    private final VirtualDataSource dataSource;
    private List<VirtualLeafRecord<K, V>> updatedLeaves;
    private List<VirtualLeafRecord<K, V>> deletedLeaves;
    private List<VirtualHashRecord> updatedHashes;
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final int flushInterval;
    private final VirtualMapStatistics statistics;

    public ReconnectHashLeafFlusher(@NonNull KeySerializer<K> keySerializer, @NonNull ValueSerializer<V> valueSerializer, @NonNull VirtualDataSource dataSource, int flushInterval, @NonNull VirtualMapStatistics statistics) {
        this.keySerializer = Objects.requireNonNull(keySerializer);
        this.valueSerializer = Objects.requireNonNull(valueSerializer);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.flushInterval = flushInterval;
        this.statistics = Objects.requireNonNull(statistics);
    }

    synchronized void start(long firstLeafPath, long lastLeafPath) {
        if (firstLeafPath != -1L && (firstLeafPath <= 0L || firstLeafPath > lastLeafPath)) {
            throw new IllegalArgumentException("The first leaf path is invalid. firstLeafPath=" + firstLeafPath + ", lastLeafPath=" + lastLeafPath);
        }
        if (lastLeafPath != -1L && lastLeafPath <= 0L) {
            throw new IllegalArgumentException("The last leaf path is invalid. firstLeafPath=" + firstLeafPath + ", lastLeafPath=" + lastLeafPath);
        }
        if (this.firstLeafPath == 0L && this.lastLeafPath == 0L) {
            this.firstLeafPath = firstLeafPath;
            this.lastLeafPath = lastLeafPath;
            assert (this.updatedHashes == null && this.updatedLeaves == null && this.deletedLeaves == null) : "Reconnect must not be started yet";
            this.updatedHashes = new ArrayList<VirtualHashRecord>();
            this.updatedLeaves = new ArrayList<VirtualLeafRecord<K, V>>();
            this.deletedLeaves = new ArrayList<VirtualLeafRecord<K, V>>();
        } else {
            assert (this.firstLeafPath == firstLeafPath);
            assert (this.lastLeafPath == lastLeafPath);
        }
    }

    void updateHash(long path, Hash hash) {
        assert (this.updatedHashes != null && this.updatedLeaves != null && this.deletedLeaves != null) : "updateHash called without start";
        this.actionAndCheckFlush(() -> this.updatedHashes.add(new VirtualHashRecord(path, hash)));
    }

    void updateLeaf(VirtualLeafRecord<K, V> leaf) {
        assert (this.updatedHashes != null && this.updatedLeaves != null && this.deletedLeaves != null) : "updateLeaf called without start";
        this.actionAndCheckFlush(() -> this.updatedLeaves.add(leaf));
    }

    void deleteLeaf(VirtualLeafRecord<K, V> leaf) {
        assert (this.updatedHashes != null && this.updatedLeaves != null && this.deletedLeaves != null) : "deleteLeaf called without start";
        this.actionAndCheckFlush(() -> this.deletedLeaves.add(leaf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionAndCheckFlush(Runnable action) {
        List<VirtualLeafRecord<K, V>> deletedLeavesToFlush;
        List<VirtualLeafRecord<K, V>> dirtyLeavesToFlush;
        List<VirtualHashRecord> dirtyHashesToFlush;
        ReconnectHashLeafFlusher reconnectHashLeafFlusher = this;
        synchronized (reconnectHashLeafFlusher) {
            action.run();
            if (!this.isFlushNeeded() || !this.flushInProgress.compareAndSet(false, true)) {
                return;
            }
            dirtyHashesToFlush = this.updatedHashes;
            this.updatedHashes = new ArrayList<VirtualHashRecord>();
            dirtyLeavesToFlush = this.updatedLeaves;
            this.updatedLeaves = new ArrayList<VirtualLeafRecord<K, V>>();
            deletedLeavesToFlush = this.deletedLeaves;
            this.deletedLeaves = new ArrayList<VirtualLeafRecord<K, V>>();
        }
        this.flush(dirtyHashesToFlush, dirtyLeavesToFlush, deletedLeavesToFlush);
    }

    private boolean isFlushNeeded() {
        if (this.flushInterval <= 0) {
            return false;
        }
        return this.updatedHashes.size() >= this.flushInterval || this.updatedLeaves.size() >= this.flushInterval || this.deletedLeaves.size() >= this.flushInterval;
    }

    synchronized void finish() {
        assert (this.updatedHashes != null && this.updatedLeaves != null && this.deletedLeaves != null) : "finish called without start";
        List<VirtualHashRecord> dirtyHashesToFlush = this.updatedHashes;
        List<VirtualLeafRecord<K, V>> dirtyLeavesToFlush = this.updatedLeaves;
        List<VirtualLeafRecord<K, V>> deletedLeavesToFlush = this.deletedLeaves;
        this.updatedHashes = null;
        this.updatedLeaves = null;
        this.deletedLeaves = null;
        assert (!this.flushInProgress.get()) : "Flush must not be in progress when reconnect is finished";
        this.flushInProgress.set(true);
        this.flush(dirtyHashesToFlush, dirtyLeavesToFlush, deletedLeavesToFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(@NonNull List<VirtualHashRecord> hashesToFlush, @NonNull List<VirtualLeafRecord<K, V>> leavesToFlush, @NonNull List<VirtualLeafRecord<K, V>> leavesToDelete) {
        assert (this.flushInProgress.get()) : "Flush in progress flag must be set";
        try {
            logger.info(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Reconnect flush: {} updated hashes, {} updated leaves, {} deleted leaves", (Object)hashesToFlush.size(), (Object)leavesToFlush.size(), (Object)leavesToDelete.size());
            long start = System.currentTimeMillis();
            try {
                this.dataSource.saveRecords(this.firstLeafPath, this.lastLeafPath, hashesToFlush.stream(), leavesToFlush.stream().map(r -> r.toBytes(this.keySerializer, this.valueSerializer)), leavesToDelete.stream().map(r -> r.toBytes(this.keySerializer, this.valueSerializer)), true);
                long end = System.currentTimeMillis();
                this.statistics.recordFlush(end - start);
                logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flushed in {} ms", (Object)(end - start));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        finally {
            this.flushInProgress.set(false);
        }
    }
}

